# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOccmDemandSignalDeliveriesResult',
    'AwaitableGetOccmDemandSignalDeliveriesResult',
    'get_occm_demand_signal_deliveries',
    'get_occm_demand_signal_deliveries_output',
]

@pulumi.output_type
class GetOccmDemandSignalDeliveriesResult:
    """
    A collection of values returned by getOccmDemandSignalDeliveries.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, occm_demand_signal_delivery_collections=None, occm_demand_signal_item_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if occm_demand_signal_delivery_collections and not isinstance(occm_demand_signal_delivery_collections, list):
            raise TypeError("Expected argument 'occm_demand_signal_delivery_collections' to be a list")
        pulumi.set(__self__, "occm_demand_signal_delivery_collections", occm_demand_signal_delivery_collections)
        if occm_demand_signal_item_id and not isinstance(occm_demand_signal_item_id, str):
            raise TypeError("Expected argument 'occm_demand_signal_item_id' to be a str")
        pulumi.set(__self__, "occm_demand_signal_item_id", occm_demand_signal_item_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy from which the demand signal delivery resource is created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOccmDemandSignalDeliveriesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of this demand signal delivery resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="occmDemandSignalDeliveryCollections")
    def occm_demand_signal_delivery_collections(self) -> Sequence['outputs.GetOccmDemandSignalDeliveriesOccmDemandSignalDeliveryCollectionResult']:
        """
        The list of occm_demand_signal_delivery_collection.
        """
        return pulumi.get(self, "occm_demand_signal_delivery_collections")

    @_builtins.property
    @pulumi.getter(name="occmDemandSignalItemId")
    def occm_demand_signal_item_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "occm_demand_signal_item_id")


class AwaitableGetOccmDemandSignalDeliveriesResult(GetOccmDemandSignalDeliveriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccmDemandSignalDeliveriesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            occm_demand_signal_delivery_collections=self.occm_demand_signal_delivery_collections,
            occm_demand_signal_item_id=self.occm_demand_signal_item_id)


def get_occm_demand_signal_deliveries(compartment_id: Optional[_builtins.str] = None,
                                      filters: Optional[Sequence[Union['GetOccmDemandSignalDeliveriesFilterArgs', 'GetOccmDemandSignalDeliveriesFilterArgsDict']]] = None,
                                      id: Optional[_builtins.str] = None,
                                      occm_demand_signal_item_id: Optional[_builtins.str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccmDemandSignalDeliveriesResult:
    """
    This data source provides the list of Occm Demand Signal Deliveries in Oracle Cloud Infrastructure Capacity Management service.

    This GET call is used to list all demand signals delivery resources within the compartment passed as a query param.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occm_demand_signal_deliveries = oci.CapacityManagement.get_occm_demand_signal_deliveries(compartment_id=compartment_id,
        id=occm_demand_signal_delivery_id,
        occm_demand_signal_item_id=test_occm_demand_signal_item["id"])
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str id: A query parameter to filter the list of demand signals based on it's OCID.
    :param _builtins.str occm_demand_signal_item_id: A query parameter to filter the list of demand signal items based on it's OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['occmDemandSignalItemId'] = occm_demand_signal_item_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccmDemandSignalDeliveries:getOccmDemandSignalDeliveries', __args__, opts=opts, typ=GetOccmDemandSignalDeliveriesResult).value

    return AwaitableGetOccmDemandSignalDeliveriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        occm_demand_signal_delivery_collections=pulumi.get(__ret__, 'occm_demand_signal_delivery_collections'),
        occm_demand_signal_item_id=pulumi.get(__ret__, 'occm_demand_signal_item_id'))
def get_occm_demand_signal_deliveries_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOccmDemandSignalDeliveriesFilterArgs', 'GetOccmDemandSignalDeliveriesFilterArgsDict']]]]] = None,
                                             id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             occm_demand_signal_item_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccmDemandSignalDeliveriesResult]:
    """
    This data source provides the list of Occm Demand Signal Deliveries in Oracle Cloud Infrastructure Capacity Management service.

    This GET call is used to list all demand signals delivery resources within the compartment passed as a query param.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occm_demand_signal_deliveries = oci.CapacityManagement.get_occm_demand_signal_deliveries(compartment_id=compartment_id,
        id=occm_demand_signal_delivery_id,
        occm_demand_signal_item_id=test_occm_demand_signal_item["id"])
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str id: A query parameter to filter the list of demand signals based on it's OCID.
    :param _builtins.str occm_demand_signal_item_id: A query parameter to filter the list of demand signal items based on it's OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['occmDemandSignalItemId'] = occm_demand_signal_item_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccmDemandSignalDeliveries:getOccmDemandSignalDeliveries', __args__, opts=opts, typ=GetOccmDemandSignalDeliveriesResult)
    return __ret__.apply(lambda __response__: GetOccmDemandSignalDeliveriesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        occm_demand_signal_delivery_collections=pulumi.get(__response__, 'occm_demand_signal_delivery_collections'),
        occm_demand_signal_item_id=pulumi.get(__response__, 'occm_demand_signal_item_id')))
