# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAgentDependenciesResult',
    'AwaitableGetAgentDependenciesResult',
    'get_agent_dependencies',
    'get_agent_dependencies_output',
]

@pulumi.output_type
class GetAgentDependenciesResult:
    """
    A collection of values returned by getAgentDependencies.
    """
    def __init__(__self__, agent_dependency_collections=None, agent_id=None, compartment_id=None, display_name=None, environment_id=None, filters=None, id=None, state=None):
        if agent_dependency_collections and not isinstance(agent_dependency_collections, list):
            raise TypeError("Expected argument 'agent_dependency_collections' to be a list")
        pulumi.set(__self__, "agent_dependency_collections", agent_dependency_collections)
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="agentDependencyCollections")
    def agent_dependency_collections(self) -> Sequence['outputs.GetAgentDependenciesAgentDependencyCollectionResult']:
        """
        The list of agent_dependency_collection.
        """
        return pulumi.get(self, "agent_dependency_collections")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Compartment identifier
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        Display name of the Agent dependency.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAgentDependenciesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of AgentDependency.
        """
        return pulumi.get(self, "state")


class AwaitableGetAgentDependenciesResult(GetAgentDependenciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentDependenciesResult(
            agent_dependency_collections=self.agent_dependency_collections,
            agent_id=self.agent_id,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            environment_id=self.environment_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_agent_dependencies(agent_id: Optional[_builtins.str] = None,
                           compartment_id: Optional[_builtins.str] = None,
                           display_name: Optional[_builtins.str] = None,
                           environment_id: Optional[_builtins.str] = None,
                           filters: Optional[Sequence[Union['GetAgentDependenciesFilterArgs', 'GetAgentDependenciesFilterArgsDict']]] = None,
                           state: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentDependenciesResult:
    """
    This data source provides the list of Agent Dependencies in Oracle Cloud Infrastructure Cloud Bridge service.

    Returns a list of AgentDependencies such as AgentDependencyCollection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_dependencies = oci.CloudBridge.get_agent_dependencies(compartment_id=compartment_id,
        agent_id=test_agent["id"],
        display_name=agent_dependency_display_name,
        environment_id=test_environment["id"],
        state=agent_dependency_state)
    ```


    :param _builtins.str agent_id: A filter to return only resources that match the given Agent ID.
    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str environment_id: A filter to return only resources that match the given environment ID.
    :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['environmentId'] = environment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getAgentDependencies:getAgentDependencies', __args__, opts=opts, typ=GetAgentDependenciesResult).value

    return AwaitableGetAgentDependenciesResult(
        agent_dependency_collections=pulumi.get(__ret__, 'agent_dependency_collections'),
        agent_id=pulumi.get(__ret__, 'agent_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_agent_dependencies_output(agent_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  environment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAgentDependenciesFilterArgs', 'GetAgentDependenciesFilterArgsDict']]]]] = None,
                                  state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAgentDependenciesResult]:
    """
    This data source provides the list of Agent Dependencies in Oracle Cloud Infrastructure Cloud Bridge service.

    Returns a list of AgentDependencies such as AgentDependencyCollection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_agent_dependencies = oci.CloudBridge.get_agent_dependencies(compartment_id=compartment_id,
        agent_id=test_agent["id"],
        display_name=agent_dependency_display_name,
        environment_id=test_environment["id"],
        state=agent_dependency_state)
    ```


    :param _builtins.str agent_id: A filter to return only resources that match the given Agent ID.
    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str environment_id: A filter to return only resources that match the given environment ID.
    :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['environmentId'] = environment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudBridge/getAgentDependencies:getAgentDependencies', __args__, opts=opts, typ=GetAgentDependenciesResult)
    return __ret__.apply(lambda __response__: GetAgentDependenciesResult(
        agent_dependency_collections=pulumi.get(__response__, 'agent_dependency_collections'),
        agent_id=pulumi.get(__response__, 'agent_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
