# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInstanceCredentialsResult',
    'AwaitableGetInstanceCredentialsResult',
    'get_instance_credentials',
    'get_instance_credentials_output',
]

@pulumi.output_type
class GetInstanceCredentialsResult:
    """
    A collection of values returned by getInstanceCredentials.
    """
    def __init__(__self__, id=None, instance_id=None, password=None, username=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the username.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username.
        """
        return pulumi.get(self, "username")


class AwaitableGetInstanceCredentialsResult(GetInstanceCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceCredentialsResult(
            id=self.id,
            instance_id=self.instance_id,
            password=self.password,
            username=self.username)


def get_instance_credentials(instance_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceCredentialsResult:
    """
    This data source provides details about a specific Instance Credential resource in Oracle Cloud Infrastructure Core service.

    Gets the generated credentials for the instance. Only works for instances that require a password to log in, such as Windows.
    For certain operating systems, users will be forced to change the initial credentials.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_credential = oci.Core.get_instance_credentials(instance_id=test_instance["id"])
    ```


    :param _builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstanceCredentials:getInstanceCredentials', __args__, opts=opts, typ=GetInstanceCredentialsResult).value

    return AwaitableGetInstanceCredentialsResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        password=pulumi.get(__ret__, 'password'),
        username=pulumi.get(__ret__, 'username'))
def get_instance_credentials_output(instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceCredentialsResult]:
    """
    This data source provides details about a specific Instance Credential resource in Oracle Cloud Infrastructure Core service.

    Gets the generated credentials for the instance. Only works for instances that require a password to log in, such as Windows.
    For certain operating systems, users will be forced to change the initial credentials.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instance_credential = oci.Core.get_instance_credentials(instance_id=test_instance["id"])
    ```


    :param _builtins.str instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getInstanceCredentials:getInstanceCredentials', __args__, opts=opts, typ=GetInstanceCredentialsResult)
    return __ret__.apply(lambda __response__: GetInstanceCredentialsResult(
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        password=pulumi.get(__response__, 'password'),
        username=pulumi.get(__response__, 'username')))
