# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatabasePdbConversionHistoryEntryResult',
    'AwaitableGetDatabasePdbConversionHistoryEntryResult',
    'get_database_pdb_conversion_history_entry',
    'get_database_pdb_conversion_history_entry_output',
]

@pulumi.output_type
class GetDatabasePdbConversionHistoryEntryResult:
    """
    A collection of values returned by getDatabasePdbConversionHistoryEntry.
    """
    def __init__(__self__, action=None, additional_cdb_params=None, cdb_name=None, database_id=None, id=None, lifecycle_details=None, pdb_conversion_history_entry_id=None, source_database_id=None, state=None, target=None, target_database_id=None, time_ended=None, time_started=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if additional_cdb_params and not isinstance(additional_cdb_params, str):
            raise TypeError("Expected argument 'additional_cdb_params' to be a str")
        pulumi.set(__self__, "additional_cdb_params", additional_cdb_params)
        if cdb_name and not isinstance(cdb_name, str):
            raise TypeError("Expected argument 'cdb_name' to be a str")
        pulumi.set(__self__, "cdb_name", cdb_name)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if pdb_conversion_history_entry_id and not isinstance(pdb_conversion_history_entry_id, str):
            raise TypeError("Expected argument 'pdb_conversion_history_entry_id' to be a str")
        pulumi.set(__self__, "pdb_conversion_history_entry_id", pdb_conversion_history_entry_id)
        if source_database_id and not isinstance(source_database_id, str):
            raise TypeError("Expected argument 'source_database_id' to be a str")
        pulumi.set(__self__, "source_database_id", source_database_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target and not isinstance(target, str):
            raise TypeError("Expected argument 'target' to be a str")
        pulumi.set(__self__, "target", target)
        if target_database_id and not isinstance(target_database_id, str):
            raise TypeError("Expected argument 'target_database_id' to be a str")
        pulumi.set(__self__, "target_database_id", target_database_id)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The operations used to convert a non-container database to a pluggable database.
        * Use `PRECHECK` to run a pre-check operation on non-container database prior to converting it into a pluggable database.
        * Use `CONVERT` to convert a non-container database into a pluggable database.
        * Use `SYNC` if the non-container database was manually converted into a pluggable database using the dbcli command-line utility. Databases may need to be converted manually if the CONVERT action fails when converting a non-container database using the API.
        * Use `SYNC_ROLLBACK` if the conversion of a non-container database into a pluggable database was manually rolled back using the dbcli command line utility. Conversions may need to be manually rolled back if the CONVERT action fails when converting a non-container database using the API.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="additionalCdbParams")
    def additional_cdb_params(self) -> _builtins.str:
        """
        Additional container database parameter.
        """
        return pulumi.get(self, "additional_cdb_params")

    @_builtins.property
    @pulumi.getter(name="cdbName")
    def cdb_name(self) -> _builtins.str:
        """
        The database name. The name must begin with an alphabetic character and can contain a maximum of 8 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy.
        """
        return pulumi.get(self, "cdb_name")

    @_builtins.property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> _builtins.str:
        return pulumi.get(self, "database_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state for the conversion operation.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="pdbConversionHistoryEntryId")
    def pdb_conversion_history_entry_id(self) -> _builtins.str:
        return pulumi.get(self, "pdb_conversion_history_entry_id")

    @_builtins.property
    @pulumi.getter(name="sourceDatabaseId")
    def source_database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "source_database_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Status of an operation performed during the conversion of a non-container database to a pluggable database.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        The target container database of the pluggable database created by the database conversion operation. Currently, the database conversion operation only supports creating the pluggable database in a new container database.
        * Use `NEW_DATABASE` to specify that the pluggable database be created within a new container database in the same database home.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "target_database_id")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> _builtins.str:
        """
        The date and time when the database conversion operation ended.
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time when the database conversion operation started.
        """
        return pulumi.get(self, "time_started")


class AwaitableGetDatabasePdbConversionHistoryEntryResult(GetDatabasePdbConversionHistoryEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabasePdbConversionHistoryEntryResult(
            action=self.action,
            additional_cdb_params=self.additional_cdb_params,
            cdb_name=self.cdb_name,
            database_id=self.database_id,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            pdb_conversion_history_entry_id=self.pdb_conversion_history_entry_id,
            source_database_id=self.source_database_id,
            state=self.state,
            target=self.target,
            target_database_id=self.target_database_id,
            time_ended=self.time_ended,
            time_started=self.time_started)


def get_database_pdb_conversion_history_entry(database_id: Optional[_builtins.str] = None,
                                              pdb_conversion_history_entry_id: Optional[_builtins.str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabasePdbConversionHistoryEntryResult:
    """
    This data source provides details about a specific Database Pdb Conversion History Entry resource in Oracle Cloud Infrastructure Database service.

    Gets the details of operations performed to convert the specified database from non-container (non-CDB) to pluggable (PDB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_pdb_conversion_history_entry = oci.Database.get_database_pdb_conversion_history_entry(database_id=test_database["id"],
        pdb_conversion_history_entry_id=test_pdb_conversion_history_entry["id"])
    ```


    :param _builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str pdb_conversion_history_entry_id: The database conversion history [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['pdbConversionHistoryEntryId'] = pdb_conversion_history_entry_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabasePdbConversionHistoryEntry:getDatabasePdbConversionHistoryEntry', __args__, opts=opts, typ=GetDatabasePdbConversionHistoryEntryResult).value

    return AwaitableGetDatabasePdbConversionHistoryEntryResult(
        action=pulumi.get(__ret__, 'action'),
        additional_cdb_params=pulumi.get(__ret__, 'additional_cdb_params'),
        cdb_name=pulumi.get(__ret__, 'cdb_name'),
        database_id=pulumi.get(__ret__, 'database_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        pdb_conversion_history_entry_id=pulumi.get(__ret__, 'pdb_conversion_history_entry_id'),
        source_database_id=pulumi.get(__ret__, 'source_database_id'),
        state=pulumi.get(__ret__, 'state'),
        target=pulumi.get(__ret__, 'target'),
        target_database_id=pulumi.get(__ret__, 'target_database_id'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'))
def get_database_pdb_conversion_history_entry_output(database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                     pdb_conversion_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabasePdbConversionHistoryEntryResult]:
    """
    This data source provides details about a specific Database Pdb Conversion History Entry resource in Oracle Cloud Infrastructure Database service.

    Gets the details of operations performed to convert the specified database from non-container (non-CDB) to pluggable (PDB).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_pdb_conversion_history_entry = oci.Database.get_database_pdb_conversion_history_entry(database_id=test_database["id"],
        pdb_conversion_history_entry_id=test_pdb_conversion_history_entry["id"])
    ```


    :param _builtins.str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str pdb_conversion_history_entry_id: The database conversion history [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['pdbConversionHistoryEntryId'] = pdb_conversion_history_entry_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDatabasePdbConversionHistoryEntry:getDatabasePdbConversionHistoryEntry', __args__, opts=opts, typ=GetDatabasePdbConversionHistoryEntryResult)
    return __ret__.apply(lambda __response__: GetDatabasePdbConversionHistoryEntryResult(
        action=pulumi.get(__response__, 'action'),
        additional_cdb_params=pulumi.get(__response__, 'additional_cdb_params'),
        cdb_name=pulumi.get(__response__, 'cdb_name'),
        database_id=pulumi.get(__response__, 'database_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        pdb_conversion_history_entry_id=pulumi.get(__response__, 'pdb_conversion_history_entry_id'),
        source_database_id=pulumi.get(__response__, 'source_database_id'),
        state=pulumi.get(__response__, 'state'),
        target=pulumi.get(__response__, 'target'),
        target_database_id=pulumi.get(__response__, 'target_database_id'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started')))
