# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDatabasesResult',
    'AwaitableGetDatabasesResult',
    'get_databases',
    'get_databases_output',
]

@pulumi.output_type
class GetDatabasesResult:
    """
    A collection of values returned by getDatabases.
    """
    def __init__(__self__, compartment_id=None, databases=None, db_home_id=None, db_name=None, filters=None, id=None, state=None, system_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if db_home_id and not isinstance(db_home_id, str):
            raise TypeError("Expected argument 'db_home_id' to be a str")
        pulumi.set(__self__, "db_home_id", db_home_id)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_id and not isinstance(system_id, str):
            raise TypeError("Expected argument 'system_id' to be a str")
        pulumi.set(__self__, "system_id", system_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetDatabasesDatabaseResult']:
        """
        The list of databases.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[_builtins.str]:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemId")
    def system_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "system_id")


class AwaitableGetDatabasesResult(GetDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabasesResult(
            compartment_id=self.compartment_id,
            databases=self.databases,
            db_home_id=self.db_home_id,
            db_name=self.db_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            system_id=self.system_id)


def get_databases(compartment_id: Optional[_builtins.str] = None,
                  db_home_id: Optional[_builtins.str] = None,
                  db_name: Optional[_builtins.str] = None,
                  filters: Optional[Sequence[Union['GetDatabasesFilterArgs', 'GetDatabasesFilterArgsDict']]] = None,
                  state: Optional[_builtins.str] = None,
                  system_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabasesResult:
    """
    This data source provides the list of Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the databases in the specified Database Home.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_databases = oci.Database.get_databases(compartment_id=compartment_id,
        db_home_id=test_db_home["id"],
        db_name=database_db_name,
        state=database_state,
        system_id=test_system["id"])
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str db_home_id: A Database Home [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). *Note: Either `db_home_id` or `system_id` is required to make the LIST API call.
    :param _builtins.str db_name: A filter to return only resources that match the entire database name given. The match is not case sensitive.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param _builtins.str system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata DB system that you want to filter the database results by. Applies only to Exadata DB systems.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbHomeId'] = db_home_id
    __args__['dbName'] = db_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['systemId'] = system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabases:getDatabases', __args__, opts=opts, typ=GetDatabasesResult).value

    return AwaitableGetDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        databases=pulumi.get(__ret__, 'databases'),
        db_home_id=pulumi.get(__ret__, 'db_home_id'),
        db_name=pulumi.get(__ret__, 'db_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        system_id=pulumi.get(__ret__, 'system_id'))
def get_databases_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                         db_home_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         db_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDatabasesFilterArgs', 'GetDatabasesFilterArgsDict']]]]] = None,
                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         system_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabasesResult]:
    """
    This data source provides the list of Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of the databases in the specified Database Home.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_databases = oci.Database.get_databases(compartment_id=compartment_id,
        db_home_id=test_db_home["id"],
        db_name=database_db_name,
        state=database_state,
        system_id=test_system["id"])
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str db_home_id: A Database Home [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). *Note: Either `db_home_id` or `system_id` is required to make the LIST API call.
    :param _builtins.str db_name: A filter to return only resources that match the entire database name given. The match is not case sensitive.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    :param _builtins.str system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata DB system that you want to filter the database results by. Applies only to Exadata DB systems.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['dbHomeId'] = db_home_id
    __args__['dbName'] = db_name
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['systemId'] = system_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDatabases:getDatabases', __args__, opts=opts, typ=GetDatabasesResult)
    return __ret__.apply(lambda __response__: GetDatabasesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        databases=pulumi.get(__response__, 'databases'),
        db_home_id=pulumi.get(__response__, 'db_home_id'),
        db_name=pulumi.get(__response__, 'db_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        system_id=pulumi.get(__response__, 'system_id')))
