# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDbSystemsUpgradeHistoryEntryResult',
    'AwaitableGetDbSystemsUpgradeHistoryEntryResult',
    'get_db_systems_upgrade_history_entry',
    'get_db_systems_upgrade_history_entry_output',
]

@pulumi.output_type
class GetDbSystemsUpgradeHistoryEntryResult:
    """
    A collection of values returned by getDbSystemsUpgradeHistoryEntry.
    """
    def __init__(__self__, action=None, db_system_id=None, id=None, lifecycle_details=None, new_gi_version=None, new_os_version=None, old_gi_version=None, old_os_version=None, snapshot_retention_period_in_days=None, state=None, time_ended=None, time_started=None, upgrade_history_entry_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if new_gi_version and not isinstance(new_gi_version, str):
            raise TypeError("Expected argument 'new_gi_version' to be a str")
        pulumi.set(__self__, "new_gi_version", new_gi_version)
        if new_os_version and not isinstance(new_os_version, str):
            raise TypeError("Expected argument 'new_os_version' to be a str")
        pulumi.set(__self__, "new_os_version", new_os_version)
        if old_gi_version and not isinstance(old_gi_version, str):
            raise TypeError("Expected argument 'old_gi_version' to be a str")
        pulumi.set(__self__, "old_gi_version", old_gi_version)
        if old_os_version and not isinstance(old_os_version, str):
            raise TypeError("Expected argument 'old_os_version' to be a str")
        pulumi.set(__self__, "old_os_version", old_os_version)
        if snapshot_retention_period_in_days and not isinstance(snapshot_retention_period_in_days, int):
            raise TypeError("Expected argument 'snapshot_retention_period_in_days' to be a int")
        pulumi.set(__self__, "snapshot_retention_period_in_days", snapshot_retention_period_in_days)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if upgrade_history_entry_id and not isinstance(upgrade_history_entry_id, str):
            raise TypeError("Expected argument 'upgrade_history_entry_id' to be a str")
        pulumi.set(__self__, "upgrade_history_entry_id", upgrade_history_entry_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The operating system upgrade action.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> _builtins.str:
        return pulumi.get(self, "db_system_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        A descriptive text associated with the lifecycleState. Typically contains additional displayable text.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="newGiVersion")
    def new_gi_version(self) -> _builtins.str:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "new_gi_version")

    @_builtins.property
    @pulumi.getter(name="newOsVersion")
    def new_os_version(self) -> _builtins.str:
        """
        A valid Oracle Software (OS) version eg. Oracle Linux Server release 8
        """
        return pulumi.get(self, "new_os_version")

    @_builtins.property
    @pulumi.getter(name="oldGiVersion")
    def old_gi_version(self) -> _builtins.str:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "old_gi_version")

    @_builtins.property
    @pulumi.getter(name="oldOsVersion")
    def old_os_version(self) -> _builtins.str:
        """
        A valid Oracle Software (OS) version eg. Oracle Linux Server release 8
        """
        return pulumi.get(self, "old_os_version")

    @_builtins.property
    @pulumi.getter(name="snapshotRetentionPeriodInDays")
    def snapshot_retention_period_in_days(self) -> _builtins.int:
        """
        The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.
        """
        return pulumi.get(self, "snapshot_retention_period_in_days")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the action.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> _builtins.str:
        """
        The date and time when the upgrade action completed
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time when the upgrade action started.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="upgradeHistoryEntryId")
    def upgrade_history_entry_id(self) -> _builtins.str:
        return pulumi.get(self, "upgrade_history_entry_id")


class AwaitableGetDbSystemsUpgradeHistoryEntryResult(GetDbSystemsUpgradeHistoryEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemsUpgradeHistoryEntryResult(
            action=self.action,
            db_system_id=self.db_system_id,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            new_gi_version=self.new_gi_version,
            new_os_version=self.new_os_version,
            old_gi_version=self.old_gi_version,
            old_os_version=self.old_os_version,
            snapshot_retention_period_in_days=self.snapshot_retention_period_in_days,
            state=self.state,
            time_ended=self.time_ended,
            time_started=self.time_started,
            upgrade_history_entry_id=self.upgrade_history_entry_id)


def get_db_systems_upgrade_history_entry(db_system_id: Optional[_builtins.str] = None,
                                         upgrade_history_entry_id: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemsUpgradeHistoryEntryResult:
    """
    This data source provides details about a specific Db Systems Upgrade History Entry resource in Oracle Cloud Infrastructure Database service.

    Gets the details of the specified operating system upgrade operation for the specified DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems_upgrade_history_entry = oci.Database.get_db_systems_upgrade_history_entry(db_system_id=test_db_system["id"],
        upgrade_history_entry_id=test_upgrade_history_entry["id"])
    ```


    :param _builtins.str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str upgrade_history_entry_id: The database/db system upgrade History [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    __args__['upgradeHistoryEntryId'] = upgrade_history_entry_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbSystemsUpgradeHistoryEntry:getDbSystemsUpgradeHistoryEntry', __args__, opts=opts, typ=GetDbSystemsUpgradeHistoryEntryResult).value

    return AwaitableGetDbSystemsUpgradeHistoryEntryResult(
        action=pulumi.get(__ret__, 'action'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        new_gi_version=pulumi.get(__ret__, 'new_gi_version'),
        new_os_version=pulumi.get(__ret__, 'new_os_version'),
        old_gi_version=pulumi.get(__ret__, 'old_gi_version'),
        old_os_version=pulumi.get(__ret__, 'old_os_version'),
        snapshot_retention_period_in_days=pulumi.get(__ret__, 'snapshot_retention_period_in_days'),
        state=pulumi.get(__ret__, 'state'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'),
        upgrade_history_entry_id=pulumi.get(__ret__, 'upgrade_history_entry_id'))
def get_db_systems_upgrade_history_entry_output(db_system_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                upgrade_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSystemsUpgradeHistoryEntryResult]:
    """
    This data source provides details about a specific Db Systems Upgrade History Entry resource in Oracle Cloud Infrastructure Database service.

    Gets the details of the specified operating system upgrade operation for the specified DB system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_systems_upgrade_history_entry = oci.Database.get_db_systems_upgrade_history_entry(db_system_id=test_db_system["id"],
        upgrade_history_entry_id=test_upgrade_history_entry["id"])
    ```


    :param _builtins.str db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str upgrade_history_entry_id: The database/db system upgrade History [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    __args__['upgradeHistoryEntryId'] = upgrade_history_entry_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbSystemsUpgradeHistoryEntry:getDbSystemsUpgradeHistoryEntry', __args__, opts=opts, typ=GetDbSystemsUpgradeHistoryEntryResult)
    return __ret__.apply(lambda __response__: GetDbSystemsUpgradeHistoryEntryResult(
        action=pulumi.get(__response__, 'action'),
        db_system_id=pulumi.get(__response__, 'db_system_id'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        new_gi_version=pulumi.get(__response__, 'new_gi_version'),
        new_os_version=pulumi.get(__response__, 'new_os_version'),
        old_gi_version=pulumi.get(__response__, 'old_gi_version'),
        old_os_version=pulumi.get(__response__, 'old_os_version'),
        snapshot_retention_period_in_days=pulumi.get(__response__, 'snapshot_retention_period_in_days'),
        state=pulumi.get(__response__, 'state'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started'),
        upgrade_history_entry_id=pulumi.get(__response__, 'upgrade_history_entry_id')))
