# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCloudAsmInstancesResult',
    'AwaitableGetCloudAsmInstancesResult',
    'get_cloud_asm_instances',
    'get_cloud_asm_instances_output',
]

@pulumi.output_type
class GetCloudAsmInstancesResult:
    """
    A collection of values returned by getCloudAsmInstances.
    """
    def __init__(__self__, cloud_asm_id=None, cloud_asm_instance_collections=None, compartment_id=None, display_name=None, filters=None, id=None):
        if cloud_asm_id and not isinstance(cloud_asm_id, str):
            raise TypeError("Expected argument 'cloud_asm_id' to be a str")
        pulumi.set(__self__, "cloud_asm_id", cloud_asm_id)
        if cloud_asm_instance_collections and not isinstance(cloud_asm_instance_collections, list):
            raise TypeError("Expected argument 'cloud_asm_instance_collections' to be a list")
        pulumi.set(__self__, "cloud_asm_instance_collections", cloud_asm_instance_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="cloudAsmId")
    def cloud_asm_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM that the ASM instance belongs to.
        """
        return pulumi.get(self, "cloud_asm_id")

    @_builtins.property
    @pulumi.getter(name="cloudAsmInstanceCollections")
    def cloud_asm_instance_collections(self) -> Sequence['outputs.GetCloudAsmInstancesCloudAsmInstanceCollectionResult']:
        """
        The list of cloud_asm_instance_collection.
        """
        return pulumi.get(self, "cloud_asm_instance_collections")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the ASM instance. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCloudAsmInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCloudAsmInstancesResult(GetCloudAsmInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudAsmInstancesResult(
            cloud_asm_id=self.cloud_asm_id,
            cloud_asm_instance_collections=self.cloud_asm_instance_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id)


def get_cloud_asm_instances(cloud_asm_id: Optional[_builtins.str] = None,
                            compartment_id: Optional[_builtins.str] = None,
                            display_name: Optional[_builtins.str] = None,
                            filters: Optional[Sequence[Union['GetCloudAsmInstancesFilterArgs', 'GetCloudAsmInstancesFilterArgsDict']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudAsmInstancesResult:
    """
    This data source provides the list of Cloud Asm Instances in Oracle Cloud Infrastructure Database Management service.

    Lists the ASM instances in the specified cloud ASM.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm_instances = oci.DatabaseManagement.get_cloud_asm_instances(cloud_asm_id=test_cloud_asm["id"],
        compartment_id=compartment_id,
        display_name=cloud_asm_instance_display_name)
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getCloudAsmInstances:getCloudAsmInstances', __args__, opts=opts, typ=GetCloudAsmInstancesResult).value

    return AwaitableGetCloudAsmInstancesResult(
        cloud_asm_id=pulumi.get(__ret__, 'cloud_asm_id'),
        cloud_asm_instance_collections=pulumi.get(__ret__, 'cloud_asm_instance_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_cloud_asm_instances_output(cloud_asm_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCloudAsmInstancesFilterArgs', 'GetCloudAsmInstancesFilterArgsDict']]]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudAsmInstancesResult]:
    """
    This data source provides the list of Cloud Asm Instances in Oracle Cloud Infrastructure Database Management service.

    Lists the ASM instances in the specified cloud ASM.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_asm_instances = oci.DatabaseManagement.get_cloud_asm_instances(cloud_asm_id=test_cloud_asm["id"],
        compartment_id=compartment_id,
        display_name=cloud_asm_instance_display_name)
    ```


    :param _builtins.str cloud_asm_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud ASM.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str display_name: A filter to only return the resources that match the entire display name.
    """
    __args__ = dict()
    __args__['cloudAsmId'] = cloud_asm_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getCloudAsmInstances:getCloudAsmInstances', __args__, opts=opts, typ=GetCloudAsmInstancesResult)
    return __ret__.apply(lambda __response__: GetCloudAsmInstancesResult(
        cloud_asm_id=pulumi.get(__response__, 'cloud_asm_id'),
        cloud_asm_instance_collections=pulumi.get(__response__, 'cloud_asm_instance_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
