# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalMySqlDatabasesResult',
    'AwaitableGetExternalMySqlDatabasesResult',
    'get_external_my_sql_databases',
    'get_external_my_sql_databases_output',
]

@pulumi.output_type
class GetExternalMySqlDatabasesResult:
    """
    A collection of values returned by getExternalMySqlDatabases.
    """
    def __init__(__self__, compartment_id=None, external_my_sql_database_collections=None, filters=None, id=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if external_my_sql_database_collections and not isinstance(external_my_sql_database_collections, list):
            raise TypeError("Expected argument 'external_my_sql_database_collections' to be a list")
        pulumi.set(__self__, "external_my_sql_database_collections", external_my_sql_database_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        OCID of compartment for the External MySQL Database.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="externalMySqlDatabaseCollections")
    def external_my_sql_database_collections(self) -> Sequence['outputs.GetExternalMySqlDatabasesExternalMySqlDatabaseCollectionResult']:
        """
        The list of external_my_sql_database_collection.
        """
        return pulumi.get(self, "external_my_sql_database_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalMySqlDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


class AwaitableGetExternalMySqlDatabasesResult(GetExternalMySqlDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalMySqlDatabasesResult(
            compartment_id=self.compartment_id,
            external_my_sql_database_collections=self.external_my_sql_database_collections,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_external_my_sql_databases(compartment_id: Optional[_builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetExternalMySqlDatabasesFilterArgs', 'GetExternalMySqlDatabasesFilterArgsDict']]] = None,
                                  name: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalMySqlDatabasesResult:
    """
    This data source provides the list of External My Sql Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the list of External MySQL Databases.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_databases = oci.DatabaseManagement.get_external_my_sql_databases(compartment_id=compartment_id,
        name=external_my_sql_database_name)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str name: The parameter to filter by MySQL Database System type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalMySqlDatabases:getExternalMySqlDatabases', __args__, opts=opts, typ=GetExternalMySqlDatabasesResult).value

    return AwaitableGetExternalMySqlDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        external_my_sql_database_collections=pulumi.get(__ret__, 'external_my_sql_database_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_external_my_sql_databases_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExternalMySqlDatabasesFilterArgs', 'GetExternalMySqlDatabasesFilterArgsDict']]]]] = None,
                                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalMySqlDatabasesResult]:
    """
    This data source provides the list of External My Sql Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the list of External MySQL Databases.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_my_sql_databases = oci.DatabaseManagement.get_external_my_sql_databases(compartment_id=compartment_id,
        name=external_my_sql_database_name)
    ```


    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str name: The parameter to filter by MySQL Database System type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalMySqlDatabases:getExternalMySqlDatabases', __args__, opts=opts, typ=GetExternalMySqlDatabasesResult)
    return __ret__.apply(lambda __response__: GetExternalMySqlDatabasesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        external_my_sql_database_collections=pulumi.get(__response__, 'external_my_sql_database_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
