# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJobOutputResult',
    'AwaitableGetJobOutputResult',
    'get_job_output',
    'get_job_output_output',
]

@pulumi.output_type
class GetJobOutputResult:
    """
    A collection of values returned by getJobOutput.
    """
    def __init__(__self__, id=None, items=None, job_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetJobOutputItemResult']:
        """
        Items in collection.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> _builtins.str:
        return pulumi.get(self, "job_id")


class AwaitableGetJobOutputResult(GetJobOutputResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobOutputResult(
            id=self.id,
            items=self.items,
            job_id=self.job_id)


def get_job_output(job_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobOutputResult:
    """
    This data source provides details about a specific Job Output resource in Oracle Cloud Infrastructure Database Migration service.

    List the Job Outputs

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_output = oci.DatabaseMigration.get_job_output(job_id=test_job["id"])
    ```


    :param _builtins.str job_id: The OCID of the job
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseMigration/getJobOutput:getJobOutput', __args__, opts=opts, typ=GetJobOutputResult).value

    return AwaitableGetJobOutputResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        job_id=pulumi.get(__ret__, 'job_id'))
def get_job_output_output(job_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobOutputResult]:
    """
    This data source provides details about a specific Job Output resource in Oracle Cloud Infrastructure Database Migration service.

    List the Job Outputs

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_job_output = oci.DatabaseMigration.get_job_output(job_id=test_job["id"])
    ```


    :param _builtins.str job_id: The OCID of the job
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseMigration/getJobOutput:getJobOutput', __args__, opts=opts, typ=GetJobOutputResult)
    return __ret__.apply(lambda __response__: GetJobOutputResult(
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        job_id=pulumi.get(__response__, 'job_id')))
