# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityPolicyConfigsResult',
    'AwaitableGetSecurityPolicyConfigsResult',
    'get_security_policy_configs',
    'get_security_policy_configs_output',
]

@pulumi.output_type
class GetSecurityPolicyConfigsResult:
    """
    A collection of values returned by getSecurityPolicyConfigs.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, security_policy_config_collections=None, security_policy_config_id=None, security_policy_id=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_policy_config_collections and not isinstance(security_policy_config_collections, list):
            raise TypeError("Expected argument 'security_policy_config_collections' to be a list")
        pulumi.set(__self__, "security_policy_config_collections", security_policy_config_collections)
        if security_policy_config_id and not isinstance(security_policy_config_id, str):
            raise TypeError("Expected argument 'security_policy_config_id' to be a str")
        pulumi.set(__self__, "security_policy_config_id", security_policy_config_id)
        if security_policy_id and not isinstance(security_policy_id, str):
            raise TypeError("Expected argument 'security_policy_id' to be a str")
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the security policy configuration.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the security policy configuration.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityPolicyConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyConfigCollections")
    def security_policy_config_collections(self) -> Sequence['outputs.GetSecurityPolicyConfigsSecurityPolicyConfigCollectionResult']:
        """
        The list of security_policy_config_collection.
        """
        return pulumi.get(self, "security_policy_config_collections")

    @_builtins.property
    @pulumi.getter(name="securityPolicyConfigId")
    def security_policy_config_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "security_policy_config_id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the security policy corresponding to the security policy configuration.
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the security policy configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetSecurityPolicyConfigsResult(GetSecurityPolicyConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyConfigsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            security_policy_config_collections=self.security_policy_config_collections,
            security_policy_config_id=self.security_policy_config_id,
            security_policy_id=self.security_policy_id,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_security_policy_configs(access_level: Optional[_builtins.str] = None,
                                compartment_id: Optional[_builtins.str] = None,
                                compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                display_name: Optional[_builtins.str] = None,
                                filters: Optional[Sequence[Union['GetSecurityPolicyConfigsFilterArgs', 'GetSecurityPolicyConfigsFilterArgsDict']]] = None,
                                security_policy_config_id: Optional[_builtins.str] = None,
                                security_policy_id: Optional[_builtins.str] = None,
                                state: Optional[_builtins.str] = None,
                                time_created_greater_than_or_equal_to: Optional[_builtins.str] = None,
                                time_created_less_than: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyConfigsResult:
    """
    This data source provides the list of Security Policy Configs in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all security policy configurations in Data Safe.

    The ListSecurityPolicyConfigs operation returns only the security policy configurations in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSecurityPolicyConfigs on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_configs = oci.DataSafe.get_security_policy_configs(compartment_id=compartment_id,
        access_level=security_policy_config_access_level,
        compartment_id_in_subtree=security_policy_config_compartment_id_in_subtree,
        display_name=security_policy_config_display_name,
        security_policy_config_id=test_security_policy_config["id"],
        security_policy_id=test_security_policy["id"],
        state=security_policy_config_state,
        time_created_greater_than_or_equal_to=security_policy_config_time_created_greater_than_or_equal_to,
        time_created_less_than=security_policy_config_time_created_less_than)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str security_policy_config_id: An optional filter to return only resources that match the specified OCID of the security policy configuration resource.
    :param _builtins.str security_policy_id: An optional filter to return only resources that match the specified OCID of the security policy resource.
    :param _builtins.str state: The current state of the security policy configuration resource.
    :param _builtins.str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param _builtins.str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['securityPolicyConfigId'] = security_policy_config_id
    __args__['securityPolicyId'] = security_policy_id
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityPolicyConfigs:getSecurityPolicyConfigs', __args__, opts=opts, typ=GetSecurityPolicyConfigsResult).value

    return AwaitableGetSecurityPolicyConfigsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        security_policy_config_collections=pulumi.get(__ret__, 'security_policy_config_collections'),
        security_policy_config_id=pulumi.get(__ret__, 'security_policy_config_id'),
        security_policy_id=pulumi.get(__ret__, 'security_policy_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))
def get_security_policy_configs_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                       display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityPolicyConfigsFilterArgs', 'GetSecurityPolicyConfigsFilterArgsDict']]]]] = None,
                                       security_policy_config_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       security_policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       time_created_less_than: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyConfigsResult]:
    """
    This data source provides the list of Security Policy Configs in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all security policy configurations in Data Safe.

    The ListSecurityPolicyConfigs operation returns only the security policy configurations in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSecurityPolicyConfigs on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_configs = oci.DataSafe.get_security_policy_configs(compartment_id=compartment_id,
        access_level=security_policy_config_access_level,
        compartment_id_in_subtree=security_policy_config_compartment_id_in_subtree,
        display_name=security_policy_config_display_name,
        security_policy_config_id=test_security_policy_config["id"],
        security_policy_id=test_security_policy["id"],
        state=security_policy_config_state,
        time_created_greater_than_or_equal_to=security_policy_config_time_created_greater_than_or_equal_to,
        time_created_less_than=security_policy_config_time_created_less_than)
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.str security_policy_config_id: An optional filter to return only resources that match the specified OCID of the security policy configuration resource.
    :param _builtins.str security_policy_id: An optional filter to return only resources that match the specified OCID of the security policy resource.
    :param _builtins.str state: The current state of the security policy configuration resource.
    :param _builtins.str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param _builtins.str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['securityPolicyConfigId'] = security_policy_config_id
    __args__['securityPolicyId'] = security_policy_id
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityPolicyConfigs:getSecurityPolicyConfigs', __args__, opts=opts, typ=GetSecurityPolicyConfigsResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyConfigsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        security_policy_config_collections=pulumi.get(__response__, 'security_policy_config_collections'),
        security_policy_config_id=pulumi.get(__response__, 'security_policy_config_id'),
        security_policy_id=pulumi.get(__response__, 'security_policy_id'),
        state=pulumi.get(__response__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__response__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__response__, 'time_created_less_than')))
