# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUnifiedAuditPolicyDefinitionsResult',
    'AwaitableGetUnifiedAuditPolicyDefinitionsResult',
    'get_unified_audit_policy_definitions',
    'get_unified_audit_policy_definitions_output',
]

@pulumi.output_type
class GetUnifiedAuditPolicyDefinitionsResult:
    """
    A collection of values returned by getUnifiedAuditPolicyDefinitions.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, is_seeded=None, state=None, unified_audit_policy_category=None, unified_audit_policy_definition_collections=None, unified_audit_policy_definition_id=None, unified_audit_policy_name=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_seeded and not isinstance(is_seeded, bool):
            raise TypeError("Expected argument 'is_seeded' to be a bool")
        pulumi.set(__self__, "is_seeded", is_seeded)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if unified_audit_policy_category and not isinstance(unified_audit_policy_category, str):
            raise TypeError("Expected argument 'unified_audit_policy_category' to be a str")
        pulumi.set(__self__, "unified_audit_policy_category", unified_audit_policy_category)
        if unified_audit_policy_definition_collections and not isinstance(unified_audit_policy_definition_collections, list):
            raise TypeError("Expected argument 'unified_audit_policy_definition_collections' to be a list")
        pulumi.set(__self__, "unified_audit_policy_definition_collections", unified_audit_policy_definition_collections)
        if unified_audit_policy_definition_id and not isinstance(unified_audit_policy_definition_id, str):
            raise TypeError("Expected argument 'unified_audit_policy_definition_id' to be a str")
        pulumi.set(__self__, "unified_audit_policy_definition_id", unified_audit_policy_definition_id)
        if unified_audit_policy_name and not isinstance(unified_audit_policy_name, str):
            raise TypeError("Expected argument 'unified_audit_policy_name' to be a str")
        pulumi.set(__self__, "unified_audit_policy_name", unified_audit_policy_name)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing the unified audit policy definition.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the unified audit policy definition.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUnifiedAuditPolicyDefinitionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> Optional[_builtins.bool]:
        """
        Signifies whether the unified audit policy definition is seeded or not.
        """
        return pulumi.get(self, "is_seeded")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the unified audit policy definition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyCategory")
    def unified_audit_policy_category(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unified_audit_policy_category")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionCollections")
    def unified_audit_policy_definition_collections(self) -> Sequence['outputs.GetUnifiedAuditPolicyDefinitionsUnifiedAuditPolicyDefinitionCollectionResult']:
        """
        The list of unified_audit_policy_definition_collection.
        """
        return pulumi.get(self, "unified_audit_policy_definition_collections")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyDefinitionId")
    def unified_audit_policy_definition_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unified_audit_policy_definition_id")

    @_builtins.property
    @pulumi.getter(name="unifiedAuditPolicyName")
    def unified_audit_policy_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "unified_audit_policy_name")


class AwaitableGetUnifiedAuditPolicyDefinitionsResult(GetUnifiedAuditPolicyDefinitionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUnifiedAuditPolicyDefinitionsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_seeded=self.is_seeded,
            state=self.state,
            unified_audit_policy_category=self.unified_audit_policy_category,
            unified_audit_policy_definition_collections=self.unified_audit_policy_definition_collections,
            unified_audit_policy_definition_id=self.unified_audit_policy_definition_id,
            unified_audit_policy_name=self.unified_audit_policy_name)


def get_unified_audit_policy_definitions(access_level: Optional[_builtins.str] = None,
                                         compartment_id: Optional[_builtins.str] = None,
                                         compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                         display_name: Optional[_builtins.str] = None,
                                         filters: Optional[Sequence[Union['GetUnifiedAuditPolicyDefinitionsFilterArgs', 'GetUnifiedAuditPolicyDefinitionsFilterArgsDict']]] = None,
                                         is_seeded: Optional[_builtins.bool] = None,
                                         state: Optional[_builtins.str] = None,
                                         unified_audit_policy_category: Optional[_builtins.str] = None,
                                         unified_audit_policy_definition_id: Optional[_builtins.str] = None,
                                         unified_audit_policy_name: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUnifiedAuditPolicyDefinitionsResult:
    """
    This data source provides the list of Unified Audit Policy Definitions in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all unified audit policy definitions in Data Safe.

    The ListUnifiedAuditPolicyDefinitions operation returns only the unified audit policy definitions in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requester has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListUnifiedAuditPolicyDefinitions on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_audit_policy_definitions = oci.DataSafe.get_unified_audit_policy_definitions(compartment_id=compartment_id,
        access_level=unified_audit_policy_definition_access_level,
        compartment_id_in_subtree=unified_audit_policy_definition_compartment_id_in_subtree,
        display_name=unified_audit_policy_definition_display_name,
        is_seeded=unified_audit_policy_definition_is_seeded,
        state=unified_audit_policy_definition_state,
        unified_audit_policy_category=unified_audit_policy_definition_unified_audit_policy_category,
        unified_audit_policy_definition_id=test_unified_audit_policy_definition["id"],
        unified_audit_policy_name=test_unified_audit_policy["name"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.bool is_seeded: A boolean flag indicating to list seeded unified audit policy definitions. Set this parameter to get list of seeded unified audit policy definitions.
    :param _builtins.str state: The current state of the unified audit policy definition.
    :param _builtins.str unified_audit_policy_category: The category to which the unified audit policy definition belongs to.
    :param _builtins.str unified_audit_policy_definition_id: An optional filter to return only resources that match the specified OCID of the unified audit policy definition resource.
    :param _builtins.str unified_audit_policy_name: The name of the unified audit policy.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isSeeded'] = is_seeded
    __args__['state'] = state
    __args__['unifiedAuditPolicyCategory'] = unified_audit_policy_category
    __args__['unifiedAuditPolicyDefinitionId'] = unified_audit_policy_definition_id
    __args__['unifiedAuditPolicyName'] = unified_audit_policy_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUnifiedAuditPolicyDefinitions:getUnifiedAuditPolicyDefinitions', __args__, opts=opts, typ=GetUnifiedAuditPolicyDefinitionsResult).value

    return AwaitableGetUnifiedAuditPolicyDefinitionsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_seeded=pulumi.get(__ret__, 'is_seeded'),
        state=pulumi.get(__ret__, 'state'),
        unified_audit_policy_category=pulumi.get(__ret__, 'unified_audit_policy_category'),
        unified_audit_policy_definition_collections=pulumi.get(__ret__, 'unified_audit_policy_definition_collections'),
        unified_audit_policy_definition_id=pulumi.get(__ret__, 'unified_audit_policy_definition_id'),
        unified_audit_policy_name=pulumi.get(__ret__, 'unified_audit_policy_name'))
def get_unified_audit_policy_definitions_output(access_level: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetUnifiedAuditPolicyDefinitionsFilterArgs', 'GetUnifiedAuditPolicyDefinitionsFilterArgsDict']]]]] = None,
                                                is_seeded: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                                state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                unified_audit_policy_category: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                unified_audit_policy_definition_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                unified_audit_policy_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUnifiedAuditPolicyDefinitionsResult]:
    """
    This data source provides the list of Unified Audit Policy Definitions in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all unified audit policy definitions in Data Safe.

    The ListUnifiedAuditPolicyDefinitions operation returns only the unified audit policy definitions in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requester has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListUnifiedAuditPolicyDefinitions on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_unified_audit_policy_definitions = oci.DataSafe.get_unified_audit_policy_definitions(compartment_id=compartment_id,
        access_level=unified_audit_policy_definition_access_level,
        compartment_id_in_subtree=unified_audit_policy_definition_compartment_id_in_subtree,
        display_name=unified_audit_policy_definition_display_name,
        is_seeded=unified_audit_policy_definition_is_seeded,
        state=unified_audit_policy_definition_state,
        unified_audit_policy_category=unified_audit_policy_definition_unified_audit_policy_category,
        unified_audit_policy_definition_id=test_unified_audit_policy_definition["id"],
        unified_audit_policy_name=test_unified_audit_policy["name"])
    ```


    :param _builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param _builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param _builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param _builtins.str display_name: A filter to return only resources that match the specified display name.
    :param _builtins.bool is_seeded: A boolean flag indicating to list seeded unified audit policy definitions. Set this parameter to get list of seeded unified audit policy definitions.
    :param _builtins.str state: The current state of the unified audit policy definition.
    :param _builtins.str unified_audit_policy_category: The category to which the unified audit policy definition belongs to.
    :param _builtins.str unified_audit_policy_definition_id: An optional filter to return only resources that match the specified OCID of the unified audit policy definition resource.
    :param _builtins.str unified_audit_policy_name: The name of the unified audit policy.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['isSeeded'] = is_seeded
    __args__['state'] = state
    __args__['unifiedAuditPolicyCategory'] = unified_audit_policy_category
    __args__['unifiedAuditPolicyDefinitionId'] = unified_audit_policy_definition_id
    __args__['unifiedAuditPolicyName'] = unified_audit_policy_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getUnifiedAuditPolicyDefinitions:getUnifiedAuditPolicyDefinitions', __args__, opts=opts, typ=GetUnifiedAuditPolicyDefinitionsResult)
    return __ret__.apply(lambda __response__: GetUnifiedAuditPolicyDefinitionsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_seeded=pulumi.get(__response__, 'is_seeded'),
        state=pulumi.get(__response__, 'state'),
        unified_audit_policy_category=pulumi.get(__response__, 'unified_audit_policy_category'),
        unified_audit_policy_definition_collections=pulumi.get(__response__, 'unified_audit_policy_definition_collections'),
        unified_audit_policy_definition_id=pulumi.get(__response__, 'unified_audit_policy_definition_id'),
        unified_audit_policy_name=pulumi.get(__response__, 'unified_audit_policy_name')))
