# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetModelGroupArtifactContentResult',
    'AwaitableGetModelGroupArtifactContentResult',
    'get_model_group_artifact_content',
    'get_model_group_artifact_content_output',
]

@pulumi.output_type
class GetModelGroupArtifactContentResult:
    """
    A collection of values returned by getModelGroupArtifactContent.
    """
    def __init__(__self__, id=None, model_group_id=None, range=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_group_id and not isinstance(model_group_id, str):
            raise TypeError("Expected argument 'model_group_id' to be a str")
        pulumi.set(__self__, "model_group_id", model_group_id)
        if range and not isinstance(range, str):
            raise TypeError("Expected argument 'range' to be a str")
        pulumi.set(__self__, "range", range)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="modelGroupId")
    def model_group_id(self) -> _builtins.str:
        return pulumi.get(self, "model_group_id")

    @_builtins.property
    @pulumi.getter
    def range(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "range")


class AwaitableGetModelGroupArtifactContentResult(GetModelGroupArtifactContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelGroupArtifactContentResult(
            id=self.id,
            model_group_id=self.model_group_id,
            range=self.range)


def get_model_group_artifact_content(model_group_id: Optional[_builtins.str] = None,
                                     range: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelGroupArtifactContentResult:
    """
    This data source provides details about a specific Model Group Artifact Content resource in Oracle Cloud Infrastructure Data Science service.

    Downloads the model artifact for the specified model group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_group_artifact_content = oci.DataScience.get_model_group_artifact_content(model_group_id=test_model_group["id"],
        range=model_group_artifact_content_range)
    ```


    :param _builtins.str model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
    :param _builtins.str range: Optional byte range to fetch, as described in [RFC 7233](https://tools.ietf.org/html/rfc7232#section-2.1), section 2.1. Note that only a single range of bytes is supported.
    """
    __args__ = dict()
    __args__['modelGroupId'] = model_group_id
    __args__['range'] = range
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getModelGroupArtifactContent:getModelGroupArtifactContent', __args__, opts=opts, typ=GetModelGroupArtifactContentResult).value

    return AwaitableGetModelGroupArtifactContentResult(
        id=pulumi.get(__ret__, 'id'),
        model_group_id=pulumi.get(__ret__, 'model_group_id'),
        range=pulumi.get(__ret__, 'range'))
def get_model_group_artifact_content_output(model_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            range: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelGroupArtifactContentResult]:
    """
    This data source provides details about a specific Model Group Artifact Content resource in Oracle Cloud Infrastructure Data Science service.

    Downloads the model artifact for the specified model group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_group_artifact_content = oci.DataScience.get_model_group_artifact_content(model_group_id=test_model_group["id"],
        range=model_group_artifact_content_range)
    ```


    :param _builtins.str model_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the modelGroup.
    :param _builtins.str range: Optional byte range to fetch, as described in [RFC 7233](https://tools.ietf.org/html/rfc7232#section-2.1), section 2.1. Note that only a single range of bytes is supported.
    """
    __args__ = dict()
    __args__['modelGroupId'] = model_group_id
    __args__['range'] = range
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getModelGroupArtifactContent:getModelGroupArtifactContent', __args__, opts=opts, typ=GetModelGroupArtifactContentResult)
    return __ret__.apply(lambda __response__: GetModelGroupArtifactContentResult(
        id=pulumi.get(__response__, 'id'),
        model_group_id=pulumi.get(__response__, 'model_group_id'),
        range=pulumi.get(__response__, 'range')))
