# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RepositoryRefArgs', 'RepositoryRef']

@pulumi.input_type
class RepositoryRefArgs:
    def __init__(__self__, *,
                 ref_name: pulumi.Input[_builtins.str],
                 ref_type: pulumi.Input[_builtins.str],
                 repository_id: pulumi.Input[_builtins.str],
                 commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RepositoryRef resource.
        :param pulumi.Input[_builtins.str] ref_name: A filter to return only resources that match the given reference name.
        :param pulumi.Input[_builtins.str] ref_type: (Updatable) The type of reference (BRANCH or TAG).
        :param pulumi.Input[_builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] commit_id: (Updatable) Commit ID pointed to by the new branch.
        :param pulumi.Input[_builtins.str] object_id: (Updatable) SHA-1 hash value of the object pointed to by the tag.
        """
        pulumi.set(__self__, "ref_name", ref_name)
        pulumi.set(__self__, "ref_type", ref_type)
        pulumi.set(__self__, "repository_id", repository_id)
        if commit_id is not None:
            pulumi.set(__self__, "commit_id", commit_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @_builtins.property
    @pulumi.getter(name="refName")
    def ref_name(self) -> pulumi.Input[_builtins.str]:
        """
        A filter to return only resources that match the given reference name.
        """
        return pulumi.get(self, "ref_name")

    @ref_name.setter
    def ref_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ref_name", value)

    @_builtins.property
    @pulumi.getter(name="refType")
    def ref_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The type of reference (BRANCH or TAG).
        """
        return pulumi.get(self, "ref_type")

    @ref_type.setter
    def ref_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ref_type", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Commit ID pointed to by the new branch.
        """
        return pulumi.get(self, "commit_id")

    @commit_id.setter
    def commit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_id", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) SHA-1 hash value of the object pointed to by the tag.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)


@pulumi.input_type
class _RepositoryRefState:
    def __init__(__self__, *,
                 commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 full_ref_name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_type: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RepositoryRef resources.
        :param pulumi.Input[_builtins.str] commit_id: (Updatable) Commit ID pointed to by the new branch.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] full_ref_name: Unique full reference name inside a repository.
        :param pulumi.Input[_builtins.str] object_id: (Updatable) SHA-1 hash value of the object pointed to by the tag.
        :param pulumi.Input[_builtins.str] ref_name: A filter to return only resources that match the given reference name.
        :param pulumi.Input[_builtins.str] ref_type: (Updatable) The type of reference (BRANCH or TAG).
        :param pulumi.Input[_builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if commit_id is not None:
            pulumi.set(__self__, "commit_id", commit_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if full_ref_name is not None:
            pulumi.set(__self__, "full_ref_name", full_ref_name)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if ref_name is not None:
            pulumi.set(__self__, "ref_name", ref_name)
        if ref_type is not None:
            pulumi.set(__self__, "ref_type", ref_type)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Commit ID pointed to by the new branch.
        """
        return pulumi.get(self, "commit_id")

    @commit_id.setter
    def commit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="fullRefName")
    def full_ref_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique full reference name inside a repository.
        """
        return pulumi.get(self, "full_ref_name")

    @full_ref_name.setter
    def full_ref_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_ref_name", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) SHA-1 hash value of the object pointed to by the tag.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="refName")
    def ref_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A filter to return only resources that match the given reference name.
        """
        return pulumi.get(self, "ref_name")

    @ref_name.setter
    def ref_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_name", value)

    @_builtins.property
    @pulumi.getter(name="refType")
    def ref_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The type of reference (BRANCH or TAG).
        """
        return pulumi.get(self, "ref_type")

    @ref_type.setter
    def ref_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref_type", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)


@pulumi.type_token("oci:DevOps/repositoryRef:RepositoryRef")
class RepositoryRef(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_type: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Repository Ref resource in Oracle Cloud Infrastructure Devops service.

        Creates a new reference or updates an existing one. This API will be deprecated on Wed, 12 June 2024 01:00:00 GMT as it does not get recognized when refName has '/'. This will be replaced by "/repositories/{repositoryId}/actions/createOrUpdateGitRef"

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository_ref = oci.devops.RepositoryRef("test_repository_ref",
            ref_name=repository_ref_ref_name,
            ref_type=repository_ref_ref_type,
            repository_id=test_repository["id"],
            commit_id=test_commit["id"],
            object_id=test_object["id"])
        ```

        ## Import

        RepositoryRefs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/repositoryRef:RepositoryRef test_repository_ref "repositories/{repositoryId}/refs/{refName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] commit_id: (Updatable) Commit ID pointed to by the new branch.
        :param pulumi.Input[_builtins.str] object_id: (Updatable) SHA-1 hash value of the object pointed to by the tag.
        :param pulumi.Input[_builtins.str] ref_name: A filter to return only resources that match the given reference name.
        :param pulumi.Input[_builtins.str] ref_type: (Updatable) The type of reference (BRANCH or TAG).
        :param pulumi.Input[_builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryRefArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Repository Ref resource in Oracle Cloud Infrastructure Devops service.

        Creates a new reference or updates an existing one. This API will be deprecated on Wed, 12 June 2024 01:00:00 GMT as it does not get recognized when refName has '/'. This will be replaced by "/repositories/{repositoryId}/actions/createOrUpdateGitRef"

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository_ref = oci.devops.RepositoryRef("test_repository_ref",
            ref_name=repository_ref_ref_name,
            ref_type=repository_ref_ref_type,
            repository_id=test_repository["id"],
            commit_id=test_commit["id"],
            object_id=test_object["id"])
        ```

        ## Import

        RepositoryRefs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/repositoryRef:RepositoryRef test_repository_ref "repositories/{repositoryId}/refs/{refName}"
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryRefArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryRefArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref_type: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryRefArgs.__new__(RepositoryRefArgs)

            __props__.__dict__["commit_id"] = commit_id
            __props__.__dict__["object_id"] = object_id
            if ref_name is None and not opts.urn:
                raise TypeError("Missing required property 'ref_name'")
            __props__.__dict__["ref_name"] = ref_name
            if ref_type is None and not opts.urn:
                raise TypeError("Missing required property 'ref_type'")
            __props__.__dict__["ref_type"] = ref_type
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["full_ref_name"] = None
        super(RepositoryRef, __self__).__init__(
            'oci:DevOps/repositoryRef:RepositoryRef',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commit_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            full_ref_name: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            ref_name: Optional[pulumi.Input[_builtins.str]] = None,
            ref_type: Optional[pulumi.Input[_builtins.str]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RepositoryRef':
        """
        Get an existing RepositoryRef resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] commit_id: (Updatable) Commit ID pointed to by the new branch.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] full_ref_name: Unique full reference name inside a repository.
        :param pulumi.Input[_builtins.str] object_id: (Updatable) SHA-1 hash value of the object pointed to by the tag.
        :param pulumi.Input[_builtins.str] ref_name: A filter to return only resources that match the given reference name.
        :param pulumi.Input[_builtins.str] ref_type: (Updatable) The type of reference (BRANCH or TAG).
        :param pulumi.Input[_builtins.str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryRefState.__new__(_RepositoryRefState)

        __props__.__dict__["commit_id"] = commit_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["full_ref_name"] = full_ref_name
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["ref_name"] = ref_name
        __props__.__dict__["ref_type"] = ref_type
        __props__.__dict__["repository_id"] = repository_id
        return RepositoryRef(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="commitId")
    def commit_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Commit ID pointed to by the new branch.
        """
        return pulumi.get(self, "commit_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="fullRefName")
    def full_ref_name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique full reference name inside a repository.
        """
        return pulumi.get(self, "full_ref_name")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) SHA-1 hash value of the object pointed to by the tag.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="refName")
    def ref_name(self) -> pulumi.Output[_builtins.str]:
        """
        A filter to return only resources that match the given reference name.
        """
        return pulumi.get(self, "ref_name")

    @_builtins.property
    @pulumi.getter(name="refType")
    def ref_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The type of reference (BRANCH or TAG).
        """
        return pulumi.get(self, "ref_type")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

