# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProductLicenseConsumersResult',
    'AwaitableGetProductLicenseConsumersResult',
    'get_product_license_consumers',
    'get_product_license_consumers_output',
]

@pulumi.output_type
class GetProductLicenseConsumersResult:
    """
    A collection of values returned by getProductLicenseConsumers.
    """
    def __init__(__self__, compartment_id=None, id=None, is_compartment_id_in_subtree=None, items=None, product_license_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if product_license_id and not isinstance(product_license_id, str):
            raise TypeError("Expected argument 'product_license_id' to be a str")
        pulumi.set(__self__, "product_license_id", product_license_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProductLicenseConsumersItemResult']:
        """
        Collection of product license consumers.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> _builtins.str:
        return pulumi.get(self, "product_license_id")


class AwaitableGetProductLicenseConsumersResult(GetProductLicenseConsumersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductLicenseConsumersResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            items=self.items,
            product_license_id=self.product_license_id)


def get_product_license_consumers(compartment_id: Optional[_builtins.str] = None,
                                  is_compartment_id_in_subtree: Optional[_builtins.bool] = None,
                                  product_license_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductLicenseConsumersResult:
    """
    This data source provides the list of Product License Consumers in Oracle Cloud Infrastructure License Manager service.

    Retrieves the product license consumers for a particular product license ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_license_consumers = oci.LicenseManager.get_product_license_consumers(compartment_id=compartment_id,
        product_license_id=test_product_license["id"],
        is_compartment_id_in_subtree=product_license_consumer_is_compartment_id_in_subtree)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param _builtins.bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    :param _builtins.str product_license_id: Unique product license identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['productLicenseId'] = product_license_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LicenseManager/getProductLicenseConsumers:getProductLicenseConsumers', __args__, opts=opts, typ=GetProductLicenseConsumersResult).value

    return AwaitableGetProductLicenseConsumersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__ret__, 'items'),
        product_license_id=pulumi.get(__ret__, 'product_license_id'))
def get_product_license_consumers_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                         product_license_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProductLicenseConsumersResult]:
    """
    This data source provides the list of Product License Consumers in Oracle Cloud Infrastructure License Manager service.

    Retrieves the product license consumers for a particular product license ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_license_consumers = oci.LicenseManager.get_product_license_consumers(compartment_id=compartment_id,
        product_license_id=test_product_license["id"],
        is_compartment_id_in_subtree=product_license_consumer_is_compartment_id_in_subtree)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param _builtins.bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    :param _builtins.str product_license_id: Unique product license identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['productLicenseId'] = product_license_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LicenseManager/getProductLicenseConsumers:getProductLicenseConsumers', __args__, opts=opts, typ=GetProductLicenseConsumersResult)
    return __ret__.apply(lambda __response__: GetProductLicenseConsumersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__response__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__response__, 'items'),
        product_license_id=pulumi.get(__response__, 'product_license_id')))
