# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamCdnConfigsResult',
    'AwaitableGetStreamCdnConfigsResult',
    'get_stream_cdn_configs',
    'get_stream_cdn_configs_output',
]

@pulumi.output_type
class GetStreamCdnConfigsResult:
    """
    A collection of values returned by getStreamCdnConfigs.
    """
    def __init__(__self__, display_name=None, distribution_channel_id=None, filters=None, id=None, state=None, stream_cdn_config_collections=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if distribution_channel_id and not isinstance(distribution_channel_id, str):
            raise TypeError("Expected argument 'distribution_channel_id' to be a str")
        pulumi.set(__self__, "distribution_channel_id", distribution_channel_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_cdn_config_collections and not isinstance(stream_cdn_config_collections, list):
            raise TypeError("Expected argument 'stream_cdn_config_collections' to be a list")
        pulumi.set(__self__, "stream_cdn_config_collections", stream_cdn_config_collections)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The CDN Configuration identifier or display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> _builtins.str:
        """
        Distribution Channel Identifier.
        """
        return pulumi.get(self, "distribution_channel_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamCdnConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the CDN Configuration.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamCdnConfigCollections")
    def stream_cdn_config_collections(self) -> Sequence['outputs.GetStreamCdnConfigsStreamCdnConfigCollectionResult']:
        """
        The list of stream_cdn_config_collection.
        """
        return pulumi.get(self, "stream_cdn_config_collections")


class AwaitableGetStreamCdnConfigsResult(GetStreamCdnConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamCdnConfigsResult(
            display_name=self.display_name,
            distribution_channel_id=self.distribution_channel_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            stream_cdn_config_collections=self.stream_cdn_config_collections)


def get_stream_cdn_configs(display_name: Optional[_builtins.str] = None,
                           distribution_channel_id: Optional[_builtins.str] = None,
                           filters: Optional[Sequence[Union['GetStreamCdnConfigsFilterArgs', 'GetStreamCdnConfigsFilterArgsDict']]] = None,
                           id: Optional[_builtins.str] = None,
                           state: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamCdnConfigsResult:
    """
    This data source provides the list of Stream Cdn Configs in Oracle Cloud Infrastructure Media Services service.

    Lists the StreamCdnConfig.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_cdn_configs = oci.MediaServices.get_stream_cdn_configs(distribution_channel_id=test_channel["id"],
        display_name=stream_cdn_config_display_name,
        id=stream_cdn_config_id,
        state=stream_cdn_config_state)
    ```


    :param _builtins.str display_name: A filter to return only the resources that match the entire display name given.
    :param _builtins.str distribution_channel_id: The Stream Distribution Channel identifier this CdnConfig belongs to.
    :param _builtins.str id: Unique StreamCdnConfig identifier.
    :param _builtins.str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['distributionChannelId'] = distribution_channel_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getStreamCdnConfigs:getStreamCdnConfigs', __args__, opts=opts, typ=GetStreamCdnConfigsResult).value

    return AwaitableGetStreamCdnConfigsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        distribution_channel_id=pulumi.get(__ret__, 'distribution_channel_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        stream_cdn_config_collections=pulumi.get(__ret__, 'stream_cdn_config_collections'))
def get_stream_cdn_configs_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  distribution_channel_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStreamCdnConfigsFilterArgs', 'GetStreamCdnConfigsFilterArgsDict']]]]] = None,
                                  id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamCdnConfigsResult]:
    """
    This data source provides the list of Stream Cdn Configs in Oracle Cloud Infrastructure Media Services service.

    Lists the StreamCdnConfig.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_cdn_configs = oci.MediaServices.get_stream_cdn_configs(distribution_channel_id=test_channel["id"],
        display_name=stream_cdn_config_display_name,
        id=stream_cdn_config_id,
        state=stream_cdn_config_state)
    ```


    :param _builtins.str display_name: A filter to return only the resources that match the entire display name given.
    :param _builtins.str distribution_channel_id: The Stream Distribution Channel identifier this CdnConfig belongs to.
    :param _builtins.str id: Unique StreamCdnConfig identifier.
    :param _builtins.str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['distributionChannelId'] = distribution_channel_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:MediaServices/getStreamCdnConfigs:getStreamCdnConfigs', __args__, opts=opts, typ=GetStreamCdnConfigsResult)
    return __ret__.apply(lambda __response__: GetStreamCdnConfigsResult(
        display_name=pulumi.get(__response__, 'display_name'),
        distribution_channel_id=pulumi.get(__response__, 'distribution_channel_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        stream_cdn_config_collections=pulumi.get(__response__, 'stream_cdn_config_collections')))
