# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkFirewallPolicyNatRulesResult',
    'AwaitableGetNetworkFirewallPolicyNatRulesResult',
    'get_network_firewall_policy_nat_rules',
    'get_network_firewall_policy_nat_rules_output',
]

@pulumi.output_type
class GetNetworkFirewallPolicyNatRulesResult:
    """
    A collection of values returned by getNetworkFirewallPolicyNatRules.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, nat_rule_collections=None, nat_rule_priority_order=None, network_firewall_policy_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if nat_rule_collections and not isinstance(nat_rule_collections, list):
            raise TypeError("Expected argument 'nat_rule_collections' to be a list")
        pulumi.set(__self__, "nat_rule_collections", nat_rule_collections)
        if nat_rule_priority_order and not isinstance(nat_rule_priority_order, int):
            raise TypeError("Expected argument 'nat_rule_priority_order' to be a int")
        pulumi.set(__self__, "nat_rule_priority_order", nat_rule_priority_order)
        if network_firewall_policy_id and not isinstance(network_firewall_policy_id, str):
            raise TypeError("Expected argument 'network_firewall_policy_id' to be a str")
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNetworkFirewallPolicyNatRulesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="natRuleCollections")
    def nat_rule_collections(self) -> Sequence['outputs.GetNetworkFirewallPolicyNatRulesNatRuleCollectionResult']:
        """
        The list of nat_rule_collection.
        """
        return pulumi.get(self, "nat_rule_collections")

    @_builtins.property
    @pulumi.getter(name="natRulePriorityOrder")
    def nat_rule_priority_order(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "nat_rule_priority_order")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> _builtins.str:
        return pulumi.get(self, "network_firewall_policy_id")


class AwaitableGetNetworkFirewallPolicyNatRulesResult(GetNetworkFirewallPolicyNatRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPolicyNatRulesResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            nat_rule_collections=self.nat_rule_collections,
            nat_rule_priority_order=self.nat_rule_priority_order,
            network_firewall_policy_id=self.network_firewall_policy_id)


def get_network_firewall_policy_nat_rules(display_name: Optional[_builtins.str] = None,
                                          filters: Optional[Sequence[Union['GetNetworkFirewallPolicyNatRulesFilterArgs', 'GetNetworkFirewallPolicyNatRulesFilterArgsDict']]] = None,
                                          nat_rule_priority_order: Optional[_builtins.int] = None,
                                          network_firewall_policy_id: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPolicyNatRulesResult:
    """
    This data source provides the list of Network Firewall Policy Nat Rules in Oracle Cloud Infrastructure Network Firewall service.

    Returns a list of NAT Rules for the Network Firewall Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_firewall_policy_nat_rules = oci.NetworkFirewall.get_network_firewall_policy_nat_rules(network_firewall_policy_id=test_network_firewall_policy["id"],
        display_name=network_firewall_policy_nat_rule_display_name,
        nat_rule_priority_order=network_firewall_policy_nat_rule_nat_rule_priority_order)
    ```


    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.int nat_rule_priority_order: Unique priority order for NAT Rules in the network firewall policy.
    :param _builtins.str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['natRulePriorityOrder'] = nat_rule_priority_order
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicyNatRules:getNetworkFirewallPolicyNatRules', __args__, opts=opts, typ=GetNetworkFirewallPolicyNatRulesResult).value

    return AwaitableGetNetworkFirewallPolicyNatRulesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        nat_rule_collections=pulumi.get(__ret__, 'nat_rule_collections'),
        nat_rule_priority_order=pulumi.get(__ret__, 'nat_rule_priority_order'),
        network_firewall_policy_id=pulumi.get(__ret__, 'network_firewall_policy_id'))
def get_network_firewall_policy_nat_rules_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkFirewallPolicyNatRulesFilterArgs', 'GetNetworkFirewallPolicyNatRulesFilterArgsDict']]]]] = None,
                                                 nat_rule_priority_order: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkFirewallPolicyNatRulesResult]:
    """
    This data source provides the list of Network Firewall Policy Nat Rules in Oracle Cloud Infrastructure Network Firewall service.

    Returns a list of NAT Rules for the Network Firewall Policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_firewall_policy_nat_rules = oci.NetworkFirewall.get_network_firewall_policy_nat_rules(network_firewall_policy_id=test_network_firewall_policy["id"],
        display_name=network_firewall_policy_nat_rule_display_name,
        nat_rule_priority_order=network_firewall_policy_nat_rule_nat_rule_priority_order)
    ```


    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.int nat_rule_priority_order: Unique priority order for NAT Rules in the network firewall policy.
    :param _builtins.str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['natRulePriorityOrder'] = nat_rule_priority_order
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkFirewall/getNetworkFirewallPolicyNatRules:getNetworkFirewallPolicyNatRules', __args__, opts=opts, typ=GetNetworkFirewallPolicyNatRulesResult)
    return __ret__.apply(lambda __response__: GetNetworkFirewallPolicyNatRulesResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        nat_rule_collections=pulumi.get(__response__, 'nat_rule_collections'),
        nat_rule_priority_order=pulumi.get(__response__, 'nat_rule_priority_order'),
        network_firewall_policy_id=pulumi.get(__response__, 'network_firewall_policy_id')))
