# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbmulticloudOracleDbAzureConnectorResult',
    'AwaitableGetDbmulticloudOracleDbAzureConnectorResult',
    'get_dbmulticloud_oracle_db_azure_connector',
    'get_dbmulticloud_oracle_db_azure_connector_output',
]

@pulumi.output_type
class GetDbmulticloudOracleDbAzureConnectorResult:
    """
    A collection of values returned by getDbmulticloudOracleDbAzureConnector.
    """
    def __init__(__self__, access_token=None, arc_agent_nodes=None, azure_identity_mechanism=None, azure_resource_group=None, azure_subscription_id=None, azure_tenant_id=None, compartment_id=None, db_cluster_resource_id=None, display_name=None, id=None, last_modification=None, lifecycle_state_details=None, oracle_db_azure_connector_id=None, state=None, time_created=None, time_updated=None):
        if access_token and not isinstance(access_token, str):
            raise TypeError("Expected argument 'access_token' to be a str")
        pulumi.set(__self__, "access_token", access_token)
        if arc_agent_nodes and not isinstance(arc_agent_nodes, list):
            raise TypeError("Expected argument 'arc_agent_nodes' to be a list")
        pulumi.set(__self__, "arc_agent_nodes", arc_agent_nodes)
        if azure_identity_mechanism and not isinstance(azure_identity_mechanism, str):
            raise TypeError("Expected argument 'azure_identity_mechanism' to be a str")
        pulumi.set(__self__, "azure_identity_mechanism", azure_identity_mechanism)
        if azure_resource_group and not isinstance(azure_resource_group, str):
            raise TypeError("Expected argument 'azure_resource_group' to be a str")
        pulumi.set(__self__, "azure_resource_group", azure_resource_group)
        if azure_subscription_id and not isinstance(azure_subscription_id, str):
            raise TypeError("Expected argument 'azure_subscription_id' to be a str")
        pulumi.set(__self__, "azure_subscription_id", azure_subscription_id)
        if azure_tenant_id and not isinstance(azure_tenant_id, str):
            raise TypeError("Expected argument 'azure_tenant_id' to be a str")
        pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_cluster_resource_id and not isinstance(db_cluster_resource_id, str):
            raise TypeError("Expected argument 'db_cluster_resource_id' to be a str")
        pulumi.set(__self__, "db_cluster_resource_id", db_cluster_resource_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modification and not isinstance(last_modification, str):
            raise TypeError("Expected argument 'last_modification' to be a str")
        pulumi.set(__self__, "last_modification", last_modification)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if oracle_db_azure_connector_id and not isinstance(oracle_db_azure_connector_id, str):
            raise TypeError("Expected argument 'oracle_db_azure_connector_id' to be a str")
        pulumi.set(__self__, "oracle_db_azure_connector_id", oracle_db_azure_connector_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> _builtins.str:
        """
        Azure bearer access token. If bearer access token is provided then Service Principal detail is not required.
        """
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="arcAgentNodes")
    def arc_agent_nodes(self) -> Sequence['outputs.GetDbmulticloudOracleDbAzureConnectorArcAgentNodeResult']:
        """
        List of All VMs where Arc Agent is Install under VMCluster.
        """
        return pulumi.get(self, "arc_agent_nodes")

    @_builtins.property
    @pulumi.getter(name="azureIdentityMechanism")
    def azure_identity_mechanism(self) -> _builtins.str:
        """
        Azure Identity Mechanism.
        """
        return pulumi.get(self, "azure_identity_mechanism")

    @_builtins.property
    @pulumi.getter(name="azureResourceGroup")
    def azure_resource_group(self) -> _builtins.str:
        """
        Azure Resource Group Name.
        """
        return pulumi.get(self, "azure_resource_group")

    @_builtins.property
    @pulumi.getter(name="azureSubscriptionId")
    def azure_subscription_id(self) -> _builtins.str:
        """
        Azure Subscription ID.
        """
        return pulumi.get(self, "azure_subscription_id")

    @_builtins.property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> _builtins.str:
        """
        Azure Tenant ID.
        """
        return pulumi.get(self, "azure_tenant_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment that contains Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbClusterResourceId")
    def db_cluster_resource_id(self) -> _builtins.str:
        """
        The ID of the DB Cluster Resource where this Azure Arc Agent identity to configure.
        """
        return pulumi.get(self, "db_cluster_resource_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Oracle DB Azure Connector resource name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Oracle DB Azure Connector resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModification")
    def last_modification(self) -> _builtins.str:
        """
        Description of the latest modification of the Oracle DB Azure Connector Resource.
        """
        return pulumi.get(self, "last_modification")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter(name="oracleDbAzureConnectorId")
    def oracle_db_azure_connector_id(self) -> _builtins.str:
        return pulumi.get(self, "oracle_db_azure_connector_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the Azure Arc Agent Resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the Oracle DB Azure Connector Resource was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the Oracle DB Azure Connector Resource was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDbmulticloudOracleDbAzureConnectorResult(GetDbmulticloudOracleDbAzureConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbmulticloudOracleDbAzureConnectorResult(
            access_token=self.access_token,
            arc_agent_nodes=self.arc_agent_nodes,
            azure_identity_mechanism=self.azure_identity_mechanism,
            azure_resource_group=self.azure_resource_group,
            azure_subscription_id=self.azure_subscription_id,
            azure_tenant_id=self.azure_tenant_id,
            compartment_id=self.compartment_id,
            db_cluster_resource_id=self.db_cluster_resource_id,
            display_name=self.display_name,
            id=self.id,
            last_modification=self.last_modification,
            lifecycle_state_details=self.lifecycle_state_details,
            oracle_db_azure_connector_id=self.oracle_db_azure_connector_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_dbmulticloud_oracle_db_azure_connector(oracle_db_azure_connector_id: Optional[_builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbmulticloudOracleDbAzureConnectorResult:
    """
    This data source provides details about a specific Oracle Db Azure Connector resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Get Oracle DB Azure Connector Resource form a particular Resource ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_connector = oci.oci.get_dbmulticloud_oracle_db_azure_connector(oracle_db_azure_connector_id=test_oracle_db_azure_connector_oci_dbmulticloud_oracle_db_azure_connector["id"])
    ```


    :param _builtins.str oracle_db_azure_connector_id: The ID of the Oracle DB Azure Connector Resource.
    """
    __args__ = dict()
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getDbmulticloudOracleDbAzureConnector:getDbmulticloudOracleDbAzureConnector', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureConnectorResult).value

    return AwaitableGetDbmulticloudOracleDbAzureConnectorResult(
        access_token=pulumi.get(__ret__, 'access_token'),
        arc_agent_nodes=pulumi.get(__ret__, 'arc_agent_nodes'),
        azure_identity_mechanism=pulumi.get(__ret__, 'azure_identity_mechanism'),
        azure_resource_group=pulumi.get(__ret__, 'azure_resource_group'),
        azure_subscription_id=pulumi.get(__ret__, 'azure_subscription_id'),
        azure_tenant_id=pulumi.get(__ret__, 'azure_tenant_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_cluster_resource_id=pulumi.get(__ret__, 'db_cluster_resource_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        last_modification=pulumi.get(__ret__, 'last_modification'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        oracle_db_azure_connector_id=pulumi.get(__ret__, 'oracle_db_azure_connector_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_dbmulticloud_oracle_db_azure_connector_output(oracle_db_azure_connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbmulticloudOracleDbAzureConnectorResult]:
    """
    This data source provides details about a specific Oracle Db Azure Connector resource in Oracle Cloud Infrastructure Dbmulticloud service.

    Get Oracle DB Azure Connector Resource form a particular Resource ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oracle_db_azure_connector = oci.oci.get_dbmulticloud_oracle_db_azure_connector(oracle_db_azure_connector_id=test_oracle_db_azure_connector_oci_dbmulticloud_oracle_db_azure_connector["id"])
    ```


    :param _builtins.str oracle_db_azure_connector_id: The ID of the Oracle DB Azure Connector Resource.
    """
    __args__ = dict()
    __args__['oracleDbAzureConnectorId'] = oracle_db_azure_connector_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getDbmulticloudOracleDbAzureConnector:getDbmulticloudOracleDbAzureConnector', __args__, opts=opts, typ=GetDbmulticloudOracleDbAzureConnectorResult)
    return __ret__.apply(lambda __response__: GetDbmulticloudOracleDbAzureConnectorResult(
        access_token=pulumi.get(__response__, 'access_token'),
        arc_agent_nodes=pulumi.get(__response__, 'arc_agent_nodes'),
        azure_identity_mechanism=pulumi.get(__response__, 'azure_identity_mechanism'),
        azure_resource_group=pulumi.get(__response__, 'azure_resource_group'),
        azure_subscription_id=pulumi.get(__response__, 'azure_subscription_id'),
        azure_tenant_id=pulumi.get(__response__, 'azure_tenant_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_cluster_resource_id=pulumi.get(__response__, 'db_cluster_resource_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        last_modification=pulumi.get(__response__, 'last_modification'),
        lifecycle_state_details=pulumi.get(__response__, 'lifecycle_state_details'),
        oracle_db_azure_connector_id=pulumi.get(__response__, 'oracle_db_azure_connector_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
