# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOdaInstanceResult',
    'AwaitableGetOdaInstanceResult',
    'get_oda_instance',
    'get_oda_instance_output',
]

@pulumi.output_type
class GetOdaInstanceResult:
    """
    A collection of values returned by getOdaInstance.
    """
    def __init__(__self__, attachment_ids=None, attachment_types=None, compartment_id=None, connector_url=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, identity_app_console_url=None, identity_app_guid=None, identity_domain=None, imported_package_ids=None, imported_package_names=None, is_role_based_access=None, lifecycle_sub_state=None, oda_instance_id=None, restricted_operations=None, shape_name=None, state=None, state_message=None, time_created=None, time_updated=None, web_app_url=None):
        if attachment_ids and not isinstance(attachment_ids, list):
            raise TypeError("Expected argument 'attachment_ids' to be a list")
        pulumi.set(__self__, "attachment_ids", attachment_ids)
        if attachment_types and not isinstance(attachment_types, list):
            raise TypeError("Expected argument 'attachment_types' to be a list")
        pulumi.set(__self__, "attachment_types", attachment_types)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connector_url and not isinstance(connector_url, str):
            raise TypeError("Expected argument 'connector_url' to be a str")
        pulumi.set(__self__, "connector_url", connector_url)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_app_console_url and not isinstance(identity_app_console_url, str):
            raise TypeError("Expected argument 'identity_app_console_url' to be a str")
        pulumi.set(__self__, "identity_app_console_url", identity_app_console_url)
        if identity_app_guid and not isinstance(identity_app_guid, str):
            raise TypeError("Expected argument 'identity_app_guid' to be a str")
        pulumi.set(__self__, "identity_app_guid", identity_app_guid)
        if identity_domain and not isinstance(identity_domain, str):
            raise TypeError("Expected argument 'identity_domain' to be a str")
        pulumi.set(__self__, "identity_domain", identity_domain)
        if imported_package_ids and not isinstance(imported_package_ids, list):
            raise TypeError("Expected argument 'imported_package_ids' to be a list")
        pulumi.set(__self__, "imported_package_ids", imported_package_ids)
        if imported_package_names and not isinstance(imported_package_names, list):
            raise TypeError("Expected argument 'imported_package_names' to be a list")
        pulumi.set(__self__, "imported_package_names", imported_package_names)
        if is_role_based_access and not isinstance(is_role_based_access, bool):
            raise TypeError("Expected argument 'is_role_based_access' to be a bool")
        pulumi.set(__self__, "is_role_based_access", is_role_based_access)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if oda_instance_id and not isinstance(oda_instance_id, str):
            raise TypeError("Expected argument 'oda_instance_id' to be a str")
        pulumi.set(__self__, "oda_instance_id", oda_instance_id)
        if restricted_operations and not isinstance(restricted_operations, list):
            raise TypeError("Expected argument 'restricted_operations' to be a list")
        pulumi.set(__self__, "restricted_operations", restricted_operations)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_message and not isinstance(state_message, str):
            raise TypeError("Expected argument 'state_message' to be a str")
        pulumi.set(__self__, "state_message", state_message)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if web_app_url and not isinstance(web_app_url, str):
            raise TypeError("Expected argument 'web_app_url' to be a str")
        pulumi.set(__self__, "web_app_url", web_app_url)

    @_builtins.property
    @pulumi.getter(name="attachmentIds")
    def attachment_ids(self) -> Sequence[_builtins.str]:
        """
        A list of attachment identifiers for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_ids")

    @_builtins.property
    @pulumi.getter(name="attachmentTypes")
    def attachment_types(self) -> Sequence[_builtins.str]:
        """
        A list of attachment types for this instance (if any). Use attachmentIds to get the details of the attachments.
        """
        return pulumi.get(self, "attachment_types")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        Identifier of the compartment that the instance belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectorUrl")
    def connector_url(self) -> _builtins.str:
        """
        URL for the connector's endpoint.
        """
        return pulumi.get(self, "connector_url")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Digital Assistant instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        User-defined name for the Digital Assistant instance. Avoid entering confidential information. You can change this value.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique immutable identifier that was assigned when the instance was created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="identityAppConsoleUrl")
    def identity_app_console_url(self) -> _builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the URL for the administration console used to manage the Identity Application instance Digital Assistant has created inside the user-specified identity domain.
        """
        return pulumi.get(self, "identity_app_console_url")

    @_builtins.property
    @pulumi.getter(name="identityAppGuid")
    def identity_app_guid(self) -> _builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the GUID of the Identity Application instance Digital Assistant has created inside the user-specified identity domain. This identity application instance may be used to host user roll mappings to grant access to this Digital Assistant instance for users within the identity domain.
        """
        return pulumi.get(self, "identity_app_guid")

    @_builtins.property
    @pulumi.getter(name="identityDomain")
    def identity_domain(self) -> _builtins.str:
        """
        If isRoleBasedAccess is set to true, this property specifies the identity domain that is to be used to implement this type of authorzation. Digital Assistant will create an Identity Application instance and Application Roles within this identity domain. The caller may then perform and user roll mappings they like to grant access to users within the identity domain.
        """
        return pulumi.get(self, "identity_domain")

    @_builtins.property
    @pulumi.getter(name="importedPackageIds")
    def imported_package_ids(self) -> Sequence[_builtins.str]:
        """
        A list of package ids imported into this instance (if any). Use GetImportedPackage to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_ids")

    @_builtins.property
    @pulumi.getter(name="importedPackageNames")
    def imported_package_names(self) -> Sequence[_builtins.str]:
        """
        A list of package names imported into this instance (if any). Use importedPackageIds field to get the details of the imported packages.
        """
        return pulumi.get(self, "imported_package_names")

    @_builtins.property
    @pulumi.getter(name="isRoleBasedAccess")
    def is_role_based_access(self) -> _builtins.bool:
        """
        Should this Digital Assistant instance use role-based authorization via an identity domain (true) or use the default policy-based authorization via IAM policies (false)
        """
        return pulumi.get(self, "is_role_based_access")

    @_builtins.property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> _builtins.str:
        """
        The current sub-state of the Digital Assistant instance.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @_builtins.property
    @pulumi.getter(name="odaInstanceId")
    def oda_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "oda_instance_id")

    @_builtins.property
    @pulumi.getter(name="restrictedOperations")
    def restricted_operations(self) -> Sequence['outputs.GetOdaInstanceRestrictedOperationResult']:
        """
        A list of restricted operations (across all attachments) for this instance (if any). Use GetOdaInstanceAttachment to get the details of the attachments.
        """
        return pulumi.get(self, "restricted_operations")

    @_builtins.property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> _builtins.str:
        """
        Shape or size of the instance.
        """
        return pulumi.get(self, "shape_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the Digital Assistant instance.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> _builtins.str:
        """
        A message that describes the current state in more detail. For example, actionable information about an instance that's in the `FAILED` state.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        When the Digital Assistant instance was created. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        When the Digital Assistance instance was last updated. A date-time string as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> _builtins.str:
        """
        URL for the Digital Assistant web application that's associated with the instance.
        """
        return pulumi.get(self, "web_app_url")


class AwaitableGetOdaInstanceResult(GetOdaInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOdaInstanceResult(
            attachment_ids=self.attachment_ids,
            attachment_types=self.attachment_types,
            compartment_id=self.compartment_id,
            connector_url=self.connector_url,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            identity_app_console_url=self.identity_app_console_url,
            identity_app_guid=self.identity_app_guid,
            identity_domain=self.identity_domain,
            imported_package_ids=self.imported_package_ids,
            imported_package_names=self.imported_package_names,
            is_role_based_access=self.is_role_based_access,
            lifecycle_sub_state=self.lifecycle_sub_state,
            oda_instance_id=self.oda_instance_id,
            restricted_operations=self.restricted_operations,
            shape_name=self.shape_name,
            state=self.state,
            state_message=self.state_message,
            time_created=self.time_created,
            time_updated=self.time_updated,
            web_app_url=self.web_app_url)


def get_oda_instance(oda_instance_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOdaInstanceResult:
    """
    This data source provides details about a specific Oda Instance resource in Oracle Cloud Infrastructure Digital Assistant service.

    Gets the specified Digital Assistant instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_instance = oci.Oda.get_oda_instance(oda_instance_id=test_oda_instance_oci_oda_oda_instance["id"])
    ```


    :param _builtins.str oda_instance_id: Unique Digital Assistant instance identifier.
    """
    __args__ = dict()
    __args__['odaInstanceId'] = oda_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Oda/getOdaInstance:getOdaInstance', __args__, opts=opts, typ=GetOdaInstanceResult).value

    return AwaitableGetOdaInstanceResult(
        attachment_ids=pulumi.get(__ret__, 'attachment_ids'),
        attachment_types=pulumi.get(__ret__, 'attachment_types'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connector_url=pulumi.get(__ret__, 'connector_url'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        identity_app_console_url=pulumi.get(__ret__, 'identity_app_console_url'),
        identity_app_guid=pulumi.get(__ret__, 'identity_app_guid'),
        identity_domain=pulumi.get(__ret__, 'identity_domain'),
        imported_package_ids=pulumi.get(__ret__, 'imported_package_ids'),
        imported_package_names=pulumi.get(__ret__, 'imported_package_names'),
        is_role_based_access=pulumi.get(__ret__, 'is_role_based_access'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        oda_instance_id=pulumi.get(__ret__, 'oda_instance_id'),
        restricted_operations=pulumi.get(__ret__, 'restricted_operations'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        state=pulumi.get(__ret__, 'state'),
        state_message=pulumi.get(__ret__, 'state_message'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        web_app_url=pulumi.get(__ret__, 'web_app_url'))
def get_oda_instance_output(oda_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOdaInstanceResult]:
    """
    This data source provides details about a specific Oda Instance resource in Oracle Cloud Infrastructure Digital Assistant service.

    Gets the specified Digital Assistant instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_oda_instance = oci.Oda.get_oda_instance(oda_instance_id=test_oda_instance_oci_oda_oda_instance["id"])
    ```


    :param _builtins.str oda_instance_id: Unique Digital Assistant instance identifier.
    """
    __args__ = dict()
    __args__['odaInstanceId'] = oda_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Oda/getOdaInstance:getOdaInstance', __args__, opts=opts, typ=GetOdaInstanceResult)
    return __ret__.apply(lambda __response__: GetOdaInstanceResult(
        attachment_ids=pulumi.get(__response__, 'attachment_ids'),
        attachment_types=pulumi.get(__response__, 'attachment_types'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connector_url=pulumi.get(__response__, 'connector_url'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        identity_app_console_url=pulumi.get(__response__, 'identity_app_console_url'),
        identity_app_guid=pulumi.get(__response__, 'identity_app_guid'),
        identity_domain=pulumi.get(__response__, 'identity_domain'),
        imported_package_ids=pulumi.get(__response__, 'imported_package_ids'),
        imported_package_names=pulumi.get(__response__, 'imported_package_names'),
        is_role_based_access=pulumi.get(__response__, 'is_role_based_access'),
        lifecycle_sub_state=pulumi.get(__response__, 'lifecycle_sub_state'),
        oda_instance_id=pulumi.get(__response__, 'oda_instance_id'),
        restricted_operations=pulumi.get(__response__, 'restricted_operations'),
        shape_name=pulumi.get(__response__, 'shape_name'),
        state=pulumi.get(__response__, 'state'),
        state_message=pulumi.get(__response__, 'state_message'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        web_app_url=pulumi.get(__response__, 'web_app_url')))
