/*
 * Decompiled with CFR 0.152.
 */
package cats.kernel;

import cats.kernel.Eq;
import cats.kernel.Monoid$;
import cats.kernel.Semigroup;
import java.io.Serializable;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.IterableOnce;

public interface Monoid<A>
extends Semigroup<A> {
    public static <A> Monoid<A> apply(Monoid<A> monoid) {
        return Monoid$.MODULE$.apply(monoid);
    }

    public static <A> Monoid<A> instance(A a, Function2<A, A, A> function2) {
        return Monoid$.MODULE$.instance(a, function2);
    }

    public static boolean isCommutative(Semigroup semigroup) {
        return Monoid$.MODULE$.isCommutative(semigroup);
    }

    public static boolean isIdempotent(Semigroup semigroup) {
        return Monoid$.MODULE$.isIdempotent(semigroup);
    }

    public static Object maybeCombine(Object object, Option option, Semigroup semigroup) {
        return Monoid$.MODULE$.maybeCombine(object, option, semigroup);
    }

    public static Object maybeCombine(Option option, Object object, Semigroup semigroup) {
        return Monoid$.MODULE$.maybeCombine(option, object, semigroup);
    }

    public A empty();

    public static boolean isEmpty$(Monoid $this, Object a, Eq ev) {
        return $this.isEmpty(a, ev);
    }

    default public boolean isEmpty(A a, Eq<A> ev) {
        return ev.eqv(a, this.empty());
    }

    public static Object combineN$(Monoid $this, Object a, int n) {
        return $this.combineN(a, n);
    }

    @Override
    default public A combineN(A a, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Repeated combining for monoids must have n >= 0");
        }
        return n == 0 ? this.empty() : this.repeatedCombineN(a, n);
    }

    public static Object combineAll$(Monoid $this, IterableOnce as) {
        return $this.combineAll(as);
    }

    default public A combineAll(IterableOnce<A> as) {
        return as.iterator().foldLeft(this.empty(), (Function2<Object, Object, Object> & Serializable)(x, y) -> this.combine(x, y));
    }

    public static Option combineAllOption$(Monoid $this, IterableOnce as) {
        return $this.combineAllOption(as);
    }

    @Override
    default public Option<A> combineAllOption(IterableOnce<A> as) {
        return as.iterator().isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply(this.combineAll(as));
    }

    public static Monoid reverse$(Monoid $this) {
        return $this.reverse();
    }

    @Override
    default public Monoid<A> reverse() {
        return new Monoid<A>(this){
            private final /* synthetic */ Monoid $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object empty() {
                return this.$outer.empty();
            }

            public Object combine(Object a, Object b) {
                return this.$outer.combine(b, a);
            }

            public Object combineN(Object a, int n) {
                return this.$outer.combineN(a, n);
            }

            public Monoid reverse() {
                return this.$outer;
            }
        };
    }
}

