/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.Format;
import fpp.compiler.analysis.Format$Field$Default$;
import fpp.compiler.analysis.Format$Field$Integer$;
import fpp.compiler.analysis.Format$Field$Integer$Character$;
import fpp.compiler.analysis.Format$Field$Integer$Decimal$;
import fpp.compiler.analysis.Format$Field$Integer$Hexadecimal$;
import fpp.compiler.analysis.Format$Field$Integer$Octal$;
import fpp.compiler.analysis.Format$Field$Rational$;
import fpp.compiler.analysis.Format$Field$Rational$Exponent$;
import fpp.compiler.analysis.Format$Field$Rational$Fixed$;
import fpp.compiler.analysis.Format$Field$Rational$General$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.Ast$TypeNameBool$;
import fpp.compiler.ast.Ast$TypeNameFloat$;
import fpp.compiler.ast.Ast$TypeNameInt$;
import fpp.compiler.ast.Ast$TypeNameQualIdent$;
import fpp.compiler.ast.Ast$TypeNameString$;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.TypeUtils;
import fpp.compiler.codegen.TypeUtils$;
import fpp.compiler.codegen.TypeUtils$Signed$;
import fpp.compiler.codegen.TypeUtils$Unsigned$;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class FormatCppWriter$
implements Serializable {
    public static final FormatCppWriter$ MODULE$ = new FormatCppWriter$();

    private FormatCppWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FormatCppWriter$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDecimalFormat(Ast.TypeInt name) {
        String string2;
        Tuple2<TypeUtils.Signedness, Integer> tuple2 = Tuple2$.MODULE$.apply(TypeUtils$.MODULE$.signedness(name), BoxesRunTime.boxToInteger(TypeUtils$.MODULE$.width(name)));
        if (tuple2 == null) throw new MatchError(tuple2);
        TypeUtils.Signedness signedness = tuple2._1();
        int n = BoxesRunTime.unboxToInt(tuple2._2());
        if (TypeUtils$Unsigned$.MODULE$.equals(signedness)) {
            int w = n;
            string2 = new StringBuilder(9).append("%\" PRIu").append(BoxesRunTime.boxToInteger(w).toString()).append(" \"").toString();
            return string2;
        } else {
            if (!TypeUtils$Signed$.MODULE$.equals(signedness)) throw new MatchError(tuple2);
            int w = n;
            string2 = new StringBuilder(9).append("%\" PRIi").append(BoxesRunTime.boxToInteger(w).toString()).append(" \"").toString();
        }
        return string2;
    }

    public String writeField(Format.Field f, AstNode<Ast.TypeName> tn) {
        String string2;
        Format.Field field2 = f;
        if (Format$Field$Default$.MODULE$.equals(field2)) {
            string2 = this.default$1(tn);
        } else if (field2 instanceof Format.Field.Integer) {
            Format.Field.Integer.Type type;
            Format.Field.Integer integer = Format$Field$Integer$.MODULE$.unapply((Format.Field.Integer)field2);
            Format.Field.Integer.Type t = type = integer._1();
            string2 = this.integer$1(tn, t);
        } else if (field2 instanceof Format.Field.Rational) {
            Format.Field.Rational rational = Format$Field$Rational$.MODULE$.unapply((Format.Field.Rational)field2);
            Option<BigInt> option = rational._1();
            Format.Field.Rational.Type type = rational._2();
            Option<BigInt> precision = option;
            Format.Field.Rational.Type t = type;
            string2 = this.rational$1(tn, precision, t);
        } else {
            throw new MatchError(field2);
        }
        return string2;
    }

    public String write(Format f, AstNode<Ast.TypeName> tn) {
        return f.fields().foldLeft(this.escapePercent(f.prefix()), (Function2<String, Tuple2, String> & Serializable)(a, s) -> {
            Tuple2 tuple2 = s;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Format.Field field2 = (Format.Field)tuple2._1();
            String suffix = (String)tuple2._2();
            return new StringBuilder(0).append((String)a).append(new StringBuilder(0).append(this.writeField(field2, tn)).append(this.escapePercent(suffix)).toString()).toString();
        });
    }

    public String escapePercent(String s) {
        return s.replaceAll("%", "%%");
    }

    private final String default$1(AstNode tn$1) {
        String string2;
        Ast.TypeName typeName = (Ast.TypeName)tn$1.data();
        if (typeName instanceof Ast.TypeNameFloat) {
            Ast.TypeNameFloat typeNameFloat = Ast$TypeNameFloat$.MODULE$.unapply((Ast.TypeNameFloat)typeName);
            Ast.TypeFloat typeFloat = typeNameFloat._1();
            string2 = "%f";
        } else if (typeName instanceof Ast.TypeNameInt) {
            Ast.TypeInt typeInt;
            Ast.TypeNameInt typeNameInt = Ast$TypeNameInt$.MODULE$.unapply((Ast.TypeNameInt)typeName);
            Ast.TypeInt name = typeInt = typeNameInt._1();
            string2 = this.getDecimalFormat(name);
        } else if (typeName instanceof Ast.TypeNameQualIdent) {
            Ast.TypeNameQualIdent typeNameQualIdent = Ast$TypeNameQualIdent$.MODULE$.unapply((Ast.TypeNameQualIdent)typeName);
            AstNode<Ast.QualIdent> astNode = typeNameQualIdent._1();
            string2 = "%s";
        } else if (Ast$TypeNameBool$.MODULE$.equals(typeName)) {
            string2 = "%d";
        } else if (typeName instanceof Ast.TypeNameString) {
            Ast.TypeNameString typeNameString = Ast$TypeNameString$.MODULE$.unapply((Ast.TypeNameString)typeName);
            Option<AstNode<Ast.Expr>> option = typeNameString._1();
            string2 = "%s";
        } else {
            throw new MatchError(typeName);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String integer$1(AstNode tn$2, Format.Field.Integer.Type t) {
        String string2;
        Ast.TypeName typeName = (Ast.TypeName)tn$2.data();
        if (typeName instanceof Ast.TypeNameInt) {
            Ast.TypeInt typeInt;
            Ast.TypeNameInt typeNameInt = Ast$TypeNameInt$.MODULE$.unapply((Ast.TypeNameInt)typeName);
            Ast.TypeInt name = typeInt = typeNameInt._1();
            Format.Field.Integer.Type type = t;
            if (Format$Field$Integer$Character$.MODULE$.equals(type)) {
                return "%c";
            }
            if (Format$Field$Integer$Decimal$.MODULE$.equals(type)) {
                string2 = this.getDecimalFormat(name);
                return string2;
            } else if (Format$Field$Integer$Hexadecimal$.MODULE$.equals(type)) {
                string2 = new StringBuilder(9).append("%\" PRIx").append(BoxesRunTime.boxToInteger(TypeUtils$.MODULE$.width(name)).toString()).append(" \"").toString();
                return string2;
            } else {
                if (!Format$Field$Integer$Octal$.MODULE$.equals(type)) throw new MatchError(type);
                string2 = new StringBuilder(9).append("%\" PRIo").append(BoxesRunTime.boxToInteger(TypeUtils$.MODULE$.width(name)).toString()).append(" \"").toString();
            }
            return string2;
        } else {
            string2 = this.default$1(tn$2);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String rational$1(AstNode tn$3, Option precision, Format.Field.Rational.Type t) {
        String string2;
        Ast.TypeName typeName = (Ast.TypeName)tn$3.data();
        if (typeName instanceof Ast.TypeNameFloat) {
            String string3;
            Ast.TypeNameFloat typeNameFloat = Ast$TypeNameFloat$.MODULE$.unapply((Ast.TypeNameFloat)typeName);
            Ast.TypeFloat typeFloat = typeNameFloat._1();
            Option option = precision;
            if (option instanceof Some) {
                BigInt p = (BigInt)((Some)option).value();
                string3 = new StringBuilder(1).append(".").append(p.toString()).toString();
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string3 = "";
            }
            String precisionStr = string3;
            Format.Field.Rational.Type type = t;
            if (Format$Field$Rational$Exponent$.MODULE$.equals(type)) {
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("e").toString();
                return string2;
            } else if (Format$Field$Rational$Fixed$.MODULE$.equals(type)) {
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("f").toString();
                return string2;
            } else {
                if (!Format$Field$Rational$General$.MODULE$.equals(type)) throw new MatchError(type);
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("g").toString();
            }
            return string2;
        } else {
            string2 = this.default$1(tn$3);
        }
        return string2;
    }
}

