/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.util;

import fpp.compiler.util.File;
import fpp.compiler.util.File$Path$;
import fpp.compiler.util.File$StdIn$;
import fpp.compiler.util.Location$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.parsing.input.NoPosition$;
import scala.util.parsing.input.Position;

public final class Location
implements Product,
Serializable {
    private final File file;
    private final Position pos;
    private final Option includingLoc;

    public static Location apply(File file, Position position, Option<Location> option) {
        return Location$.MODULE$.apply(file, position, option);
    }

    public static Location fromProduct(Product product) {
        return Location$.MODULE$.fromProduct(product);
    }

    public static Location unapply(Location location) {
        return Location$.MODULE$.unapply(location);
    }

    public static Option<Location> $lessinit$greater$default$3() {
        return Location$.MODULE$.$lessinit$greater$default$3();
    }

    public Location(File file, Position pos, Option<Location> includingLoc) {
        this.file = file;
        this.pos = pos;
        this.includingLoc = includingLoc;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Location)) return false;
        Location location = (Location)object;
        File file = this.file();
        File file2 = location.file();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!file.equals(file2)) return false;
        Position position = this.pos();
        Position position2 = location.pos();
        if (position == null) {
            if (position2 != null) {
                return false;
            }
        } else if (!position.equals(position2)) return false;
        Option<Location> option = this.includingLoc();
        Option<Location> option2 = location.includingLoc();
        if (option == null) {
            if (option2 == null) return true;
            return false;
        } else {
            if (!option.equals(option2)) return false;
            return true;
        }
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Location;
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public String productPrefix() {
        return "Location";
    }

    @Override
    public Object productElement(int n) {
        Option<Location> option;
        int n2 = n;
        switch (n2) {
            case 0: {
                option = this._1();
                break;
            }
            case 1: {
                option = this._2();
                break;
            }
            case 2: {
                option = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
        }
        return option;
    }

    @Override
    public String productElementName(int n) {
        String string2;
        int n2 = n;
        switch (n2) {
            case 0: {
                string2 = "file";
                break;
            }
            case 1: {
                string2 = "pos";
                break;
            }
            case 2: {
                string2 = "includingLoc";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
        }
        return string2;
    }

    public File file() {
        return this.file;
    }

    public Position pos() {
        return this.pos;
    }

    public Option<Location> includingLoc() {
        return this.includingLoc;
    }

    public String toString() {
        Position position = this.pos();
        String s1 = NoPosition$.MODULE$.equals(position) ? new StringBuilder(14).append(this.file()).append(": end of input").toString() : new StringBuilder(2).append(this.file()).append(":").append(this.pos().toString()).append("\n").append(this.pos().longString()).toString();
        String s2 = Location.showIncludes$1(this.includingLoc(), "");
        return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(s1), s2);
    }

    public Location tuLocation() {
        Option<Location> option;
        Location location = this;
        while (!None$.MODULE$.equals(option = location.includingLoc())) {
            if (option instanceof Some) {
                Location loc;
                location = loc = (Location)((Some)option).value();
                continue;
            }
            throw new MatchError(option);
        }
        return location;
    }

    public Path getNeighborPath(String fileName) {
        return Paths.get(this.getDirPath().toString(), fileName);
    }

    public Path getDirPath() {
        Path path;
        File file = this.file();
        if (file instanceof File.Path) {
            Path path2;
            File.Path path3 = File$Path$.MODULE$.unapply((File.Path)file);
            Path p = path2 = path3._1();
            path = p.getParent();
        } else if (File$StdIn$.MODULE$.equals(file)) {
            path = Paths.get("", new String[0]).toAbsolutePath().normalize();
        } else {
            throw new MatchError(file);
        }
        return path;
    }

    public Path getRelativePath(String path) {
        return this.getDirPath().resolve(path).normalize();
    }

    public Location copy(File file, Position pos, Option<Location> includingLoc) {
        return new Location(file, pos, includingLoc);
    }

    public File copy$default$1() {
        return this.file();
    }

    public Position copy$default$2() {
        return this.pos();
    }

    public Option<Location> copy$default$3() {
        return this.includingLoc();
    }

    public File _1() {
        return this.file();
    }

    public Position _2() {
        return this.pos();
    }

    public Option<Location> _3() {
        return this.includingLoc();
    }

    private static final String showIncludes$1(Option locOpt, String s) {
        Option<Location> option;
        String string2 = s;
        Option<Location> option2 = locOpt;
        while (!None$.MODULE$.equals(option = option2)) {
            if (option instanceof Some) {
                Location loc = (Location)((Some)option).value();
                Option<Location> option3 = loc.includingLoc();
                String string3 = StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(string2), new StringBuilder(16).append("\n  included at ").append(loc.file()).append(":").append(loc.pos()).toString());
                option2 = option3;
                string2 = string3;
                continue;
            }
            throw new MatchError(option);
        }
        return string2;
    }
}

