/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Applicative;
import cats.kernel.Eq;
import io.circe.ACursor$;
import io.circe.CursorOp;
import io.circe.CursorOp$DeleteGoParent$;
import io.circe.CursorOp$DownArray$;
import io.circe.CursorOp$DownField$;
import io.circe.CursorOp$DownN$;
import io.circe.CursorOp$Field$;
import io.circe.CursorOp$MoveLeft$;
import io.circe.CursorOp$MoveRight$;
import io.circe.CursorOp$MoveUp$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.PathToRoot;
import io.circe.PathToRoot$;
import io.circe.PathToRoot$PathElem$ArrayIndex$;
import io.circe.PathToRoot$PathElem$ObjectKey$;
import io.circe.cursor.ArrayCursor;
import io.circe.cursor.ObjectCursor;
import io.circe.cursor.TopCursor;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class ACursor
implements Serializable {
    private final HCursor lastCursor;
    private final CursorOp lastOp;

    public static Eq<ACursor> eqACursor() {
        return ACursor$.MODULE$.eqACursor();
    }

    public ACursor(HCursor lastCursor, CursorOp lastOp) {
        this.lastCursor = lastCursor;
        this.lastOp = lastOp;
    }

    private HCursor lastCursor() {
        return this.lastCursor;
    }

    private CursorOp lastOp() {
        return this.lastOp;
    }

    public abstract Option<Json> focus();

    public final List<CursorOp> history() {
        Builder<CursorOp, List<CursorOp>> builder = package$.MODULE$.List().newBuilder();
        for (ACursor next = this; next != null; next = next.lastCursor()) {
            if (next.lastOp() == null) continue;
            builder.$plus$eq(next.lastOp());
        }
        return builder.result();
    }

    public abstract boolean succeeded();

    public final boolean failed() {
        return !this.succeeded();
    }

    public abstract Option<HCursor> success();

    public abstract Option<Json> top();

    public HCursor root() {
        return null;
    }

    public abstract ACursor withFocus(Function1<Json, Json> var1);

    public abstract <F> Object withFocusM(Function1<Json, Object> var1, Applicative<F> var2);

    public final ACursor set(Json j) {
        return this.withFocus((Function1<Json, Json> & Serializable)_$2 -> j);
    }

    public abstract Option<Iterable<Json>> values();

    public Option<Object> index() {
        return None$.MODULE$;
    }

    public abstract Option<Iterable<String>> keys();

    public Option<String> key() {
        return None$.MODULE$;
    }

    public abstract ACursor delete();

    public abstract ACursor up();

    public abstract ACursor left();

    public abstract ACursor right();

    public abstract ACursor downArray();

    public abstract ACursor downN(int var1);

    public abstract ACursor field(String var1);

    public abstract ACursor downField(String var1);

    public final Vector pathToRoot() {
        return ACursor.loop$1(this, PathToRoot$.MODULE$.empty());
    }

    public final String pathString() {
        return PathToRoot$.MODULE$.toPathString(this.pathToRoot());
    }

    public final <A> Either<DecodingFailure, A> as(Decoder<A> d) {
        return d.tryDecode(this);
    }

    public final <A> Either<DecodingFailure, A> get(String k, Decoder<A> d) {
        return this.downField(k).as(d);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <A> Either<DecodingFailure, A> getOrElse(String k, Function0<A> fallback, Decoder<A> d) {
        Right right;
        Either<DecodingFailure, Option<A>> either = this.get(k, Decoder$.MODULE$.decodeOption(d));
        if (either instanceof Right) {
            Option option = (Option)((Right)either).value();
            if (option instanceof Some) {
                Object a = ((Some)option).value();
                right = package$.MODULE$.Right().apply(a);
                return right;
            }
            if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Right().apply(fallback.apply());
                return right;
            }
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Left l = (Left)either;
        right = (Right)((Object)l);
        return right;
    }

    public final ACursor replayOne(CursorOp op) {
        ACursor aCursor;
        CursorOp cursorOp = op;
        if (CursorOp$MoveLeft$.MODULE$.equals(cursorOp)) {
            aCursor = this.left();
        } else if (CursorOp$MoveRight$.MODULE$.equals(cursorOp)) {
            aCursor = this.right();
        } else if (CursorOp$MoveUp$.MODULE$.equals(cursorOp)) {
            aCursor = this.up();
        } else if (cursorOp instanceof CursorOp.Field) {
            String string2;
            CursorOp.Field field2 = CursorOp$Field$.MODULE$.unapply((CursorOp.Field)cursorOp);
            String k = string2 = field2._1();
            aCursor = this.field(k);
        } else if (cursorOp instanceof CursorOp.DownField) {
            String string3;
            CursorOp.DownField downField = CursorOp$DownField$.MODULE$.unapply((CursorOp.DownField)cursorOp);
            String k = string3 = downField._1();
            aCursor = this.downField(k);
        } else if (CursorOp$DownArray$.MODULE$.equals(cursorOp)) {
            aCursor = this.downArray();
        } else if (cursorOp instanceof CursorOp.DownN) {
            int n;
            CursorOp.DownN downN = CursorOp$DownN$.MODULE$.unapply((CursorOp.DownN)cursorOp);
            int n2 = n = downN._1();
            aCursor = this.downN(n2);
        } else if (CursorOp$DeleteGoParent$.MODULE$.equals(cursorOp)) {
            aCursor = this.delete();
        } else {
            throw new MatchError(cursorOp);
        }
        return aCursor;
    }

    public final ACursor replay(List<CursorOp> history) {
        return history.foldRight(this, (Function2<CursorOp, ACursor, ACursor> & Serializable)(op, c) -> c.replayOne((CursorOp)op));
    }

    private static final ACursor lastCursorParentOrLastCursor$1(ACursor cursor) {
        HCursor hCursor;
        HCursor hCursor2 = cursor.lastCursor();
        if (hCursor2 instanceof ArrayCursor) {
            ArrayCursor lastCursor = (ArrayCursor)hCursor2;
            hCursor = lastCursor.parent();
        } else if (hCursor2 instanceof ObjectCursor) {
            ObjectCursor lastCursor = (ObjectCursor)hCursor2;
            hCursor = lastCursor.parent();
        } else {
            HCursor lastCursor;
            hCursor = lastCursor = hCursor2;
        }
        return hCursor;
    }

    private static final Vector loop$1(ACursor cursor, Vector acc) {
        Vector vector;
        Vector vector2 = acc;
        ACursor aCursor = cursor;
        while (true) {
            if (aCursor == null) {
                vector = vector2;
                break;
            }
            if (aCursor.failed()) {
                CursorOp cursorOp = aCursor.lastOp();
                if (cursorOp instanceof CursorOp.Field) {
                    String string2;
                    CursorOp.Field field2 = CursorOp$Field$.MODULE$.unapply((CursorOp.Field)cursorOp);
                    String field3 = string2 = field2._1();
                    ACursor aCursor2 = ACursor.lastCursorParentOrLastCursor$1(aCursor);
                    PathToRoot.PathElem.ObjectKey objectKey = PathToRoot$PathElem$ObjectKey$.MODULE$.apply(field3);
                    Vector vector3 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, objectKey);
                    aCursor = aCursor2;
                    vector2 = vector3;
                    continue;
                }
                if (cursorOp instanceof CursorOp.DownField) {
                    String string3;
                    CursorOp.DownField downField = CursorOp$DownField$.MODULE$.unapply((CursorOp.DownField)cursorOp);
                    String field4 = string3 = downField._1();
                    ACursor aCursor3 = ACursor.lastCursorParentOrLastCursor$1(aCursor);
                    PathToRoot.PathElem.ObjectKey objectKey = PathToRoot$PathElem$ObjectKey$.MODULE$.apply(field4);
                    Vector vector4 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, objectKey);
                    aCursor = aCursor3;
                    vector2 = vector4;
                    continue;
                }
                if (CursorOp$DownArray$.MODULE$.equals(cursorOp)) {
                    ACursor aCursor4 = ACursor.lastCursorParentOrLastCursor$1(aCursor);
                    PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(0);
                    Vector vector5 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, arrayIndex);
                    aCursor = aCursor4;
                    vector2 = vector5;
                    continue;
                }
                if (cursorOp instanceof CursorOp.DownN) {
                    int n;
                    CursorOp.DownN downN = CursorOp$DownN$.MODULE$.unapply((CursorOp.DownN)cursorOp);
                    int n2 = n = downN._1();
                    ACursor aCursor5 = ACursor.lastCursorParentOrLastCursor$1(aCursor);
                    PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(n2);
                    Vector vector6 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, arrayIndex);
                    aCursor = aCursor5;
                    vector2 = vector6;
                    continue;
                }
                if (CursorOp$MoveLeft$.MODULE$.equals(cursorOp)) {
                    ACursor aCursor6 = ACursor.lastCursorParentOrLastCursor$1(aCursor);
                    PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(-1);
                    Vector vector7 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, arrayIndex);
                    aCursor = aCursor6;
                    vector2 = vector7;
                    continue;
                }
                if (CursorOp$MoveRight$.MODULE$.equals(cursorOp)) {
                    HCursor hCursor = aCursor.lastCursor();
                    if (hCursor instanceof ArrayCursor) {
                        ArrayCursor lastCursor = (ArrayCursor)hCursor;
                        HCursor hCursor2 = lastCursor.parent();
                        PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply((long)lastCursor.indexValue() + 1L);
                        Vector vector8 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, arrayIndex);
                        aCursor = hCursor2;
                        vector2 = vector8;
                        continue;
                    }
                    aCursor = aCursor.lastCursor();
                    continue;
                }
                aCursor = aCursor.lastCursor();
                continue;
            }
            ACursor aCursor7 = aCursor;
            if (aCursor7 instanceof ArrayCursor) {
                ArrayCursor cursor2 = (ArrayCursor)aCursor7;
                HCursor hCursor = cursor2.parent();
                PathToRoot.PathElem.ArrayIndex arrayIndex = PathToRoot$PathElem$ArrayIndex$.MODULE$.apply(cursor2.indexValue());
                Vector vector9 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, arrayIndex);
                aCursor = hCursor;
                vector2 = vector9;
                continue;
            }
            if (aCursor7 instanceof ObjectCursor) {
                ObjectCursor cursor3 = (ObjectCursor)aCursor7;
                HCursor hCursor = cursor3.parent();
                PathToRoot.PathElem.ObjectKey objectKey = PathToRoot$PathElem$ObjectKey$.MODULE$.apply(cursor3.keyValue());
                Vector vector10 = PathToRoot$.MODULE$.$plus$colon$extension(vector2, objectKey);
                aCursor = hCursor;
                vector2 = vector10;
                continue;
            }
            if (aCursor7 instanceof TopCursor) {
                TopCursor cursor4 = (TopCursor)aCursor7;
                vector = vector2;
                break;
            }
            aCursor = aCursor.lastCursor();
        }
        return vector;
    }
}

