/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Show;
import cats.Show$;
import cats.kernel.Eq;
import cats.package$;
import io.circe.Json;
import io.circe.Json$JArray$;
import io.circe.Json$JBoolean$;
import io.circe.Json$JNull$;
import io.circe.Json$JNumber$;
import io.circe.Json$JObject$;
import io.circe.Json$JString$;
import io.circe.JsonBigDecimal$;
import io.circe.JsonBiggerDecimal$;
import io.circe.JsonDouble$;
import io.circe.JsonFloat$;
import io.circe.JsonLong$;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.ModuleSerializationProxy;

public final class Json$
implements Mirror.Sum,
Serializable {
    public static final Json$JNull$ JNull;
    public static final Json$JBoolean$ JBoolean;
    public static final Json$JNumber$ JNumber;
    public static final Json$JString$ JString;
    public static final Json$JArray$ JArray;
    public static final Json$JObject$ JObject;
    private static final Json Null;
    private static final Json True;
    private static final Json False;
    private static final Eq eqJson;
    private static final Show showJson;
    public static final Json$ MODULE$;

    private Json$() {
    }

    static {
        MODULE$ = new Json$();
        Null = Json$JNull$.MODULE$;
        True = Json$JBoolean$.MODULE$.apply(true);
        False = Json$JBoolean$.MODULE$.apply(false);
        eqJson = package$.MODULE$.Eq().instance((Function2<Json, Json, boolean> & Serializable)(x$1, x$2) -> {
            boolean bl;
            Tuple2<Json, Json> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError(tuple2);
            Json json = tuple2._1();
            Json json2 = tuple2._2();
            if (json instanceof Json.JObject) {
                JsonObject jsonObject;
                Json.JObject jObject = Json$JObject$.MODULE$.unapply((Json.JObject)json);
                JsonObject a = jsonObject = jObject._1();
                if (json2 instanceof Json.JObject) {
                    JsonObject jsonObject2;
                    Json.JObject jObject2 = Json$JObject$.MODULE$.unapply((Json.JObject)json2);
                    JsonObject b = jsonObject2 = jObject2._1();
                    bl = JsonObject$.MODULE$.eqJsonObject().eqv(a, b);
                    return bl;
                }
            }
            if (json instanceof Json.JString) {
                String string2;
                Json.JString jString = Json$JString$.MODULE$.unapply((Json.JString)json);
                String a = string2 = jString._1();
                if (json2 instanceof Json.JString) {
                    String string3;
                    Json.JString jString2 = Json$JString$.MODULE$.unapply((Json.JString)json2);
                    String b = string3 = jString2._1();
                    String string4 = a;
                    String string5 = b;
                    if (string4 != null) {
                        if (!string4.equals(string5)) return false;
                        return true;
                    }
                    if (string5 == null) return true;
                    return false;
                }
            }
            if (json instanceof Json.JNumber) {
                JsonNumber jsonNumber;
                Json.JNumber jNumber = Json$JNumber$.MODULE$.unapply((Json.JNumber)json);
                JsonNumber a = jsonNumber = jNumber._1();
                if (json2 instanceof Json.JNumber) {
                    JsonNumber jsonNumber2;
                    Json.JNumber jNumber2 = Json$JNumber$.MODULE$.unapply((Json.JNumber)json2);
                    JsonNumber b = jsonNumber2 = jNumber2._1();
                    bl = JsonNumber$.MODULE$.eqJsonNumber().eqv(a, b);
                    return bl;
                }
            }
            if (json instanceof Json.JBoolean) {
                boolean bl2;
                Json.JBoolean jBoolean = Json$JBoolean$.MODULE$.unapply((Json.JBoolean)json);
                boolean a = bl2 = jBoolean._1();
                if (json2 instanceof Json.JBoolean) {
                    Json.JBoolean jBoolean2 = Json$JBoolean$.MODULE$.unapply((Json.JBoolean)json2);
                    boolean bl3 = jBoolean2._1();
                    boolean b = bl3;
                    if (a != b) return false;
                    return true;
                }
            }
            if (json instanceof Json.JArray) {
                Vector<Json> vector;
                Json.JArray jArray = Json$JArray$.MODULE$.unapply((Json.JArray)json);
                Vector<Json> a = vector = jArray._1();
                if (json2 instanceof Json.JArray) {
                    Vector<Json> vector2;
                    Json.JArray jArray2 = Json$JArray$.MODULE$.unapply((Json.JArray)json2);
                    Vector<Json> b = vector2 = jArray2._1();
                    bl = this.arrayEq(a, b);
                    return bl;
                }
            }
            Json x = json;
            Json y = json2;
            if (!x.isNull()) return false;
            if (!y.isNull()) return false;
            return true;
        });
        showJson = Show$.MODULE$.fromToString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Json$.class);
    }

    public final Json Null() {
        return Null;
    }

    public final Json True() {
        return True;
    }

    public final Json False() {
        return False;
    }

    public final Json obj(Seq<Tuple2<String, Json>> fields) {
        return this.fromFields(fields);
    }

    public final Json arr(Seq<Json> values) {
        return this.fromValues(values);
    }

    public final Json fromFields(Iterable<Tuple2<String, Json>> fields) {
        return Json$JObject$.MODULE$.apply(JsonObject$.MODULE$.fromIterable(fields));
    }

    public final Json fromValues(Iterable<Json> values) {
        return Json$JArray$.MODULE$.apply(values.toVector());
    }

    public final Json fromJsonObject(JsonObject value) {
        return Json$JObject$.MODULE$.apply(value);
    }

    public final Json fromJsonNumber(JsonNumber value) {
        return Json$JNumber$.MODULE$.apply(value);
    }

    public final Json fromString(String value) {
        return Json$JString$.MODULE$.apply(value);
    }

    public final Json fromBoolean(boolean value) {
        return value ? this.True() : this.False();
    }

    public final Json fromInt(int value) {
        return Json$JNumber$.MODULE$.apply(JsonLong$.MODULE$.apply(value));
    }

    public final Json fromLong(long value) {
        return Json$JNumber$.MODULE$.apply(JsonLong$.MODULE$.apply(value));
    }

    public final Option<Json> fromDouble(double value) {
        return this.isReal(value) ? Some$.MODULE$.apply(Json$JNumber$.MODULE$.apply(JsonDouble$.MODULE$.apply(value))) : None$.MODULE$;
    }

    public final Option<Json> fromFloat(float value) {
        return this.isReal(value) ? Some$.MODULE$.apply(Json$JNumber$.MODULE$.apply(JsonFloat$.MODULE$.apply(value))) : None$.MODULE$;
    }

    public final Json fromDoubleOrNull(double value) {
        return this.isReal(value) ? Json$JNumber$.MODULE$.apply(JsonDouble$.MODULE$.apply(value)) : this.Null();
    }

    public final Json fromFloatOrNull(float value) {
        return this.isReal(value) ? Json$JNumber$.MODULE$.apply(JsonFloat$.MODULE$.apply(value)) : this.Null();
    }

    public final Json fromDoubleOrString(double value) {
        return this.isReal(value) ? Json$JNumber$.MODULE$.apply(JsonDouble$.MODULE$.apply(value)) : this.fromString(Double.toString(value));
    }

    public final Json fromFloatOrString(float value) {
        return this.isReal(value) ? Json$JNumber$.MODULE$.apply(JsonFloat$.MODULE$.apply(value)) : this.fromString(Float.toString(value));
    }

    public final Json fromBigInt(BigInt value) {
        return Json$JNumber$.MODULE$.apply(JsonBiggerDecimal$.MODULE$.apply(BiggerDecimal$.MODULE$.fromBigInteger(value.underlying()), value.toString()));
    }

    public final Json fromBigDecimal(BigDecimal value) {
        return Json$JNumber$.MODULE$.apply(JsonBigDecimal$.MODULE$.apply(value.underlying()));
    }

    private boolean isReal(double value) {
        return Double.isFinite(value);
    }

    private boolean isReal(float value) {
        return Float.isFinite(value);
    }

    private final boolean arrayEq(Seq<Json> x, Seq<Json> y) {
        Iterator it0 = x.iterator();
        Iterator it1 = y.iterator();
        while (it0.hasNext() && it1.hasNext()) {
            if (!this.eqJson().neqv((Json)it0.next(), (Json)it1.next())) continue;
            return false;
        }
        return it0.hasNext() == it1.hasNext();
    }

    public final Eq<Json> eqJson() {
        return eqJson;
    }

    public final Show<Json> showJson() {
        return showJson;
    }

    public int ordinal(Json x$0) {
        int n;
        Json json = x$0;
        if (json == Json$JNull$.MODULE$) {
            n = 0;
        } else if (json instanceof Json.JBoolean) {
            n = 1;
        } else if (json instanceof Json.JNumber) {
            n = 2;
        } else if (json instanceof Json.JString) {
            n = 3;
        } else if (json instanceof Json.JArray) {
            n = 4;
        } else if (json instanceof Json.JObject) {
            n = 5;
        } else {
            throw new MatchError(json);
        }
        return n;
    }
}

