/*
 * Decompiled with CFR 0.152.
 */
package io.circe.jawn;

import cats.data.NonEmptyList;
import cats.data.Validated;
import io.circe.Decoder;
import io.circe.Error;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.jawn.JawnParser;
import java.io.File;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.util.Either;

public interface JawnParserPlatform {
    public static Either parsePath$(JawnParserPlatform $this, Path path) {
        return $this.parsePath(path);
    }

    default public Either<ParsingFailure, Json> parsePath(Path path) {
        return this.parseChannel(Files.newByteChannel(path, new OpenOption[0]));
    }

    public static Either parseFile$(JawnParserPlatform $this, File file) {
        return $this.parseFile(file);
    }

    default public Either<ParsingFailure, Json> parseFile(File file) {
        return ((JawnParser)this).fromTry(((JawnParser)this).supportParser().parseFromFile(file));
    }

    public static Either parseChannel$(JawnParserPlatform $this, ReadableByteChannel ch) {
        return $this.parseChannel(ch);
    }

    default public Either<ParsingFailure, Json> parseChannel(ReadableByteChannel ch) {
        return ((JawnParser)this).fromTry(((JawnParser)this).supportParser().parseFromChannel(ch));
    }

    public static Either decodePath$(JawnParserPlatform $this, Path path, Decoder evidence$1) {
        return $this.decodePath(path, evidence$1);
    }

    default public <A> Either<Error, A> decodePath(Path path, Decoder<A> evidence$1) {
        return ((JawnParser)this).finishDecode((Either)this.parsePath(path), (Decoder)evidence$1);
    }

    public static Validated decodePathAccumulating$(JawnParserPlatform $this, Path path, Decoder evidence$2) {
        return $this.decodePathAccumulating(path, evidence$2);
    }

    default public <A> Validated<NonEmptyList<Error>, A> decodePathAccumulating(Path path, Decoder<A> evidence$2) {
        return ((JawnParser)this).finishDecodeAccumulating((Either)this.parsePath(path), (Decoder)evidence$2);
    }

    public static Either decodeFile$(JawnParserPlatform $this, File file, Decoder evidence$3) {
        return $this.decodeFile(file, evidence$3);
    }

    default public <A> Either<Error, A> decodeFile(File file, Decoder<A> evidence$3) {
        return ((JawnParser)this).finishDecode((Either)this.parseFile(file), (Decoder)evidence$3);
    }

    public static Validated decodeFileAccumulating$(JawnParserPlatform $this, File file, Decoder evidence$4) {
        return $this.decodeFileAccumulating(file, evidence$4);
    }

    default public <A> Validated<NonEmptyList<Error>, A> decodeFileAccumulating(File file, Decoder<A> evidence$4) {
        return ((JawnParser)this).finishDecodeAccumulating((Either)this.parseFile(file), (Decoder)evidence$4);
    }

    public static Either decodeChannel$(JawnParserPlatform $this, ReadableByteChannel ch, Decoder evidence$5) {
        return $this.decodeChannel(ch, evidence$5);
    }

    default public <A> Either<Error, A> decodeChannel(ReadableByteChannel ch, Decoder<A> evidence$5) {
        return ((JawnParser)this).finishDecode((Either)this.parseChannel(ch), (Decoder)evidence$5);
    }

    public static Validated decodeChannelAccumulating$(JawnParserPlatform $this, ReadableByteChannel ch, Decoder evidence$6) {
        return $this.decodeChannelAccumulating(ch, evidence$6);
    }

    default public <A> Validated<NonEmptyList<Error>, A> decodeChannelAccumulating(ReadableByteChannel ch, Decoder<A> evidence$6) {
        return ((JawnParser)this).finishDecodeAccumulating((Either)this.parseChannel(ch), (Decoder)evidence$6);
    }
}

