"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Hook,
    HookTriggerResponse,
    HookTypeParam,
    HookTypeParamPlain,
    HookUpdate,
    HookUpdatePlain,
)


class HooksApiService(DevopnessBaseService):
    """
    HooksApiService - Auto Generated
    """

    def delete_hook(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Delete a given hook

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint, hook_type)

        return DevopnessResponse(response, None)

    def get_hook(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
    ) -> DevopnessResponse[Hook]:
        """
        Get a hook by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint, hook_type)

        return DevopnessResponse(response, Hook)

    def trigger_hook(
        self,
        hook_id: str,
    ) -> DevopnessResponse[HookTriggerResponse]:
        """
        Trigger an incoming hook associated action

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_id}/trigger",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint)

        return DevopnessResponse(response, HookTriggerResponse)

    def update_hook(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
        hook_update: Union[
            HookUpdate,
            HookUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing hook

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, hook_update)

        return DevopnessResponse(response, None)


class HooksApiServiceAsync(DevopnessBaseServiceAsync):
    """
    HooksApiServiceAsync - Auto Generated
    """

    async def delete_hook(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Delete a given hook

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint, hook_type)

        return DevopnessResponse(response, None)

    async def get_hook(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
    ) -> DevopnessResponse[Hook]:
        """
        Get a hook by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint, hook_type)

        return DevopnessResponse(response, Hook)

    async def trigger_hook(
        self,
        hook_id: str,
    ) -> DevopnessResponse[HookTriggerResponse]:
        """
        Trigger an incoming hook associated action

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_id}/trigger",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint)

        return DevopnessResponse(response, HookTriggerResponse)

    async def update_hook(
        self,
        hook_id: str,
        hook_type: Union[
            HookTypeParam,
            HookTypeParamPlain,
        ],
        hook_update: Union[
            HookUpdate,
            HookUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing hook

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/hooks/{hook_type}/{hook_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, hook_update)

        return DevopnessResponse(response, None)
