"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Subnet,
    SubnetNetworkCreate,
    SubnetNetworkCreatePlain,
    SubnetRelation,
)
from ..utils import parse_query_string


class NetworksSubnetsApiService(DevopnessBaseService):
    """
    NetworksSubnetsApiService - Auto Generated
    """

    def add_network_subnet(
        self,
        network_id: int,
        subnet_network_create: Union[
            SubnetNetworkCreate,
            SubnetNetworkCreatePlain,
        ],
    ) -> DevopnessResponse[Subnet]:
        """
        Create a new subnet for the given network

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/networks/{network_id}/subnets",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, subnet_network_create)

        return DevopnessResponse(response, Subnet)

    def list_network_subnets(
        self,
        network_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
        region: Optional[str] = None,
        zone: Optional[str] = None,
    ) -> DevopnessResponse[List[SubnetRelation]]:
        """
        Return a list of all subnets belonging to a network

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
                "region": region,
                "zone": zone,
            }
        )

        endpoint_parts = [
            f"/networks/{network_id}/subnets",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[SubnetRelation])


class NetworksSubnetsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    NetworksSubnetsApiServiceAsync - Auto Generated
    """

    async def add_network_subnet(
        self,
        network_id: int,
        subnet_network_create: Union[
            SubnetNetworkCreate,
            SubnetNetworkCreatePlain,
        ],
    ) -> DevopnessResponse[Subnet]:
        """
        Create a new subnet for the given network

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/networks/{network_id}/subnets",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, subnet_network_create)

        return DevopnessResponse(response, Subnet)

    async def list_network_subnets(
        self,
        network_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
        region: Optional[str] = None,
        zone: Optional[str] = None,
    ) -> DevopnessResponse[List[SubnetRelation]]:
        """
        Return a list of all subnets belonging to a network

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
                "region": region,
                "zone": zone,
            }
        )

        endpoint_parts = [
            f"/networks/{network_id}/subnets",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[SubnetRelation])
