"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Organization,
    OrganizationActivity,
    OrganizationCreate,
    OrganizationCreatePlain,
    OrganizationRelation,
    OrganizationUpdate,
    OrganizationUpdatePlain,
)
from ..utils import parse_query_string


class OrganizationsApiService(DevopnessBaseService):
    """
    OrganizationsApiService - Auto Generated
    """

    def add_organization(
        self,
        organization_create: Union[
            OrganizationCreate,
            OrganizationCreatePlain,
        ],
    ) -> DevopnessResponse[Organization]:
        """
        Create a new organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/organizations",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, organization_create)

        return DevopnessResponse(response, Organization)

    def get_organization(
        self,
        organization_id: str,
    ) -> DevopnessResponse[Organization]:
        """
        Get an organization by ID or URL Slug

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, Organization)

    def get_organization_activity(
        self,
        organization_id: str,
    ) -> DevopnessResponse[OrganizationActivity]:
        """
        Get activity information for an organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}/activity",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, OrganizationActivity)

    def list_organizations(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[OrganizationRelation]]:
        """
        List all organizations of authenticated user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/organizations",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[OrganizationRelation])

    def update_organization(
        self,
        organization_id: str,
        organization_update: Union[
            OrganizationUpdate,
            OrganizationUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, organization_update)

        return DevopnessResponse(response, None)


class OrganizationsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    OrganizationsApiServiceAsync - Auto Generated
    """

    async def add_organization(
        self,
        organization_create: Union[
            OrganizationCreate,
            OrganizationCreatePlain,
        ],
    ) -> DevopnessResponse[Organization]:
        """
        Create a new organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            "/organizations",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, organization_create)

        return DevopnessResponse(response, Organization)

    async def get_organization(
        self,
        organization_id: str,
    ) -> DevopnessResponse[Organization]:
        """
        Get an organization by ID or URL Slug

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, Organization)

    async def get_organization_activity(
        self,
        organization_id: str,
    ) -> DevopnessResponse[OrganizationActivity]:
        """
        Get activity information for an organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}/activity",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, OrganizationActivity)

    async def list_organizations(
        self,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[OrganizationRelation]]:
        """
        List all organizations of authenticated user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            "/organizations",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[OrganizationRelation])

    async def update_organization(
        self,
        organization_id: str,
        organization_update: Union[
            OrganizationUpdate,
            OrganizationUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing organization

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/organizations/{organization_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, organization_update)

        return DevopnessResponse(response, None)
