"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Step,
    StepPipelineCreate,
    StepPipelineCreatePlain,
    StepPipelineUpdate,
    StepPipelineUpdatePlain,
)


class PipelinesStepsApiService(DevopnessBaseService):
    """
    PipelinesStepsApiService - Auto Generated
    """

    def add_pipeline_step(
        self,
        pipeline_id: int,
        step_pipeline_create: Union[
            StepPipelineCreate,
            StepPipelineCreatePlain,
        ],
    ) -> DevopnessResponse[Step]:
        """
        Add a step to a pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, step_pipeline_create)

        return DevopnessResponse(response, Step)

    def link_step_to_pipeline(
        self,
        pipeline_id: int,
        step_id: int,
    ) -> DevopnessResponse[None]:
        """
        Link a step to a Pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps/{step_id}/link",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint)

        return DevopnessResponse(response, None)

    def unlink_step_from_pipeline(
        self,
        pipeline_id: int,
        step_id: int,
    ) -> DevopnessResponse[None]:
        """
        Unlink a step from a Pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps/{step_id}/unlink",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def update_pipeline_step(
        self,
        pipeline_id: int,
        step_id: int,
        step_pipeline_update: Union[
            StepPipelineUpdate,
            StepPipelineUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing Pipeline Step

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps/{step_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, step_pipeline_update)

        return DevopnessResponse(response, None)


class PipelinesStepsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    PipelinesStepsApiServiceAsync - Auto Generated
    """

    async def add_pipeline_step(
        self,
        pipeline_id: int,
        step_pipeline_create: Union[
            StepPipelineCreate,
            StepPipelineCreatePlain,
        ],
    ) -> DevopnessResponse[Step]:
        """
        Add a step to a pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, step_pipeline_create)

        return DevopnessResponse(response, Step)

    async def link_step_to_pipeline(
        self,
        pipeline_id: int,
        step_id: int,
    ) -> DevopnessResponse[None]:
        """
        Link a step to a Pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps/{step_id}/link",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint)

        return DevopnessResponse(response, None)

    async def unlink_step_from_pipeline(
        self,
        pipeline_id: int,
        step_id: int,
    ) -> DevopnessResponse[None]:
        """
        Unlink a step from a Pipeline

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps/{step_id}/unlink",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def update_pipeline_step(
        self,
        pipeline_id: int,
        step_id: int,
        step_pipeline_update: Union[
            StepPipelineUpdate,
            StepPipelineUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing Pipeline Step

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/pipelines/{pipeline_id}/steps/{step_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, step_pipeline_update)

        return DevopnessResponse(response, None)
