"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import Team, TeamProjectCreate, TeamProjectCreatePlain, TeamRelation
from ..utils import parse_query_string


class ProjectsTeamsApiService(DevopnessBaseService):
    """
    ProjectsTeamsApiService - Auto Generated
    """

    def add_project_team(
        self,
        project_id: int,
        team_project_create: Union[
            TeamProjectCreate,
            TeamProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Team]:
        """
        Create a team to the given project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/teams",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, team_project_create)

        return DevopnessResponse(response, Team)

    def list_project_teams(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[TeamRelation]]:
        """
        Return a list of all teams belonging to a project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/teams",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[TeamRelation])


class ProjectsTeamsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ProjectsTeamsApiServiceAsync - Auto Generated
    """

    async def add_project_team(
        self,
        project_id: int,
        team_project_create: Union[
            TeamProjectCreate,
            TeamProjectCreatePlain,
        ],
    ) -> DevopnessResponse[Team]:
        """
        Create a team to the given project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/projects/{project_id}/teams",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, team_project_create)

        return DevopnessResponse(response, Team)

    async def list_project_teams(
        self,
        project_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[TeamRelation]]:
        """
        Return a list of all teams belonging to a project

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/projects/{project_id}/teams",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[TeamRelation])
