"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Service,
    ServiceEnvironmentCreate,
    ServiceEnvironmentCreatePlain,
    ServiceGetStatus,
    ServiceGetStatusPlain,
    ServiceRelation,
    ServiceReload,
    ServiceReloadPlain,
    ServiceRestart,
    ServiceRestartPlain,
    ServiceStart,
    ServiceStartPlain,
    ServiceStop,
    ServiceStopPlain,
    ServiceUpdate,
    ServiceUpdatePlain,
)
from ..utils import parse_query_string


class ServicesApiService(DevopnessBaseService):
    """
    ServicesApiService - Auto Generated
    """

    def add_environment_service(
        self,
        environment_id: int,
        service_environment_create: Union[
            ServiceEnvironmentCreate,
            ServiceEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[Service]:
        """
        Add a Service to the given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/services",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, service_environment_create)

        return DevopnessResponse(response, Service)

    def delete_service(
        self,
        service_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_service(
        self,
        service_id: int,
    ) -> DevopnessResponse[Service]:
        """
        Get details of a single service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, Service)

    def get_status_service(
        self,
        service_id: int,
        service_get_status: Union[
            ServiceGetStatus,
            ServiceGetStatusPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Get current status of a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/get-status",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, service_get_status)

        return DevopnessResponse(response, None)

    def list_environment_services(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ServiceRelation]]:
        """
        Return a list of all services belonging to a environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/services",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[ServiceRelation])

    def reload_service(
        self,
        service_id: int,
        service_reload: Union[
            ServiceReload,
            ServiceReloadPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Reload a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/reload",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, service_reload)

        return DevopnessResponse(response, None)

    def restart_service(
        self,
        service_id: int,
        service_restart: Union[
            ServiceRestart,
            ServiceRestartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Restart a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/restart",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, service_restart)

        return DevopnessResponse(response, None)

    def start_service(
        self,
        service_id: int,
        service_start: Union[
            ServiceStart,
            ServiceStartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Start a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/start",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, service_start)

        return DevopnessResponse(response, None)

    def stop_service(
        self,
        service_id: int,
        service_stop: Union[
            ServiceStop,
            ServiceStopPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Stop a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/stop",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, service_stop)

        return DevopnessResponse(response, None)

    def update_service(
        self,
        service_id: int,
        service_update: Union[
            ServiceUpdate,
            ServiceUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, service_update)

        return DevopnessResponse(response, None)


class ServicesApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ServicesApiServiceAsync - Auto Generated
    """

    async def add_environment_service(
        self,
        environment_id: int,
        service_environment_create: Union[
            ServiceEnvironmentCreate,
            ServiceEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[Service]:
        """
        Add a Service to the given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/services",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, service_environment_create)

        return DevopnessResponse(response, Service)

    async def delete_service(
        self,
        service_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_service(
        self,
        service_id: int,
    ) -> DevopnessResponse[Service]:
        """
        Get details of a single service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, Service)

    async def get_status_service(
        self,
        service_id: int,
        service_get_status: Union[
            ServiceGetStatus,
            ServiceGetStatusPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Get current status of a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/get-status",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, service_get_status)

        return DevopnessResponse(response, None)

    async def list_environment_services(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[ServiceRelation]]:
        """
        Return a list of all services belonging to a environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/services",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[ServiceRelation])

    async def reload_service(
        self,
        service_id: int,
        service_reload: Union[
            ServiceReload,
            ServiceReloadPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Reload a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/reload",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, service_reload)

        return DevopnessResponse(response, None)

    async def restart_service(
        self,
        service_id: int,
        service_restart: Union[
            ServiceRestart,
            ServiceRestartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Restart a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/restart",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, service_restart)

        return DevopnessResponse(response, None)

    async def start_service(
        self,
        service_id: int,
        service_start: Union[
            ServiceStart,
            ServiceStartPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Start a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/start",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, service_start)

        return DevopnessResponse(response, None)

    async def stop_service(
        self,
        service_id: int,
        service_stop: Union[
            ServiceStop,
            ServiceStopPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Stop a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/stop",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, service_stop)

        return DevopnessResponse(response, None)

    async def update_service(
        self,
        service_id: int,
        service_update: Union[
            ServiceUpdate,
            ServiceUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, service_update)

        return DevopnessResponse(response, None)
