"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    Variable,
    VariableRelation,
    VariableServiceCreate,
    VariableServiceCreatePlain,
)
from ..utils import parse_query_string


class ServicesVariablesApiService(DevopnessBaseService):
    """
    ServicesVariablesApiService - Auto Generated
    """

    def add_service_variable(
        self,
        service_id: int,
        variable_service_create: Union[
            VariableServiceCreate,
            VariableServiceCreatePlain,
        ],
    ) -> DevopnessResponse[Variable]:
        """
        Create a new variable linked to a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/variables",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, variable_service_create)

        return DevopnessResponse(response, Variable)

    def list_service_variables(
        self,
        service_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[VariableRelation]]:
        """
        Return a list of variables belonging to a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/services/{service_id}/variables",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[VariableRelation])


class ServicesVariablesApiServiceAsync(DevopnessBaseServiceAsync):
    """
    ServicesVariablesApiServiceAsync - Auto Generated
    """

    async def add_service_variable(
        self,
        service_id: int,
        variable_service_create: Union[
            VariableServiceCreate,
            VariableServiceCreatePlain,
        ],
    ) -> DevopnessResponse[Variable]:
        """
        Create a new variable linked to a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/services/{service_id}/variables",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, variable_service_create)

        return DevopnessResponse(response, Variable)

    async def list_service_variables(
        self,
        service_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[VariableRelation]]:
        """
        Return a list of variables belonging to a service

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/services/{service_id}/variables",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[VariableRelation])
