"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    SshKey,
    SshKeyEnvironmentCreate,
    SshKeyEnvironmentCreatePlain,
    SshKeyRelation,
    SshKeyUpdate,
    SshKeyUpdatePlain,
)
from ..utils import parse_query_string


class SSHKeysApiService(DevopnessBaseService):
    """
    SSHKeysApiService - Auto Generated
    """

    def add_environment_ssh_key(
        self,
        environment_id: int,
        ssh_key_environment_create: Union[
            SshKeyEnvironmentCreate,
            SshKeyEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[SshKey]:
        """
        Create an SSH key and link it to the given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/ssh-keys",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, ssh_key_environment_create)

        return DevopnessResponse(response, SshKey)

    def delete_ssh_key(
        self,
        ssh_key_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given SSH key

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssh-keys/{ssh_key_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_ssh_key(
        self,
        ssh_key_id: int,
    ) -> DevopnessResponse[SshKey]:
        """
        Get a SSH key by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssh-keys/{ssh_key_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, SshKey)

    def list_environment_ssh_keys(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[SshKeyRelation]]:
        """
        Return a list of all SSH keys added to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/ssh-keys",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[SshKeyRelation])

    def update_ssh_key(
        self,
        ssh_key_id: int,
        ssh_key_update: Union[
            SshKeyUpdate,
            SshKeyUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing SSH key

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssh-keys/{ssh_key_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, ssh_key_update)

        return DevopnessResponse(response, None)


class SSHKeysApiServiceAsync(DevopnessBaseServiceAsync):
    """
    SSHKeysApiServiceAsync - Auto Generated
    """

    async def add_environment_ssh_key(
        self,
        environment_id: int,
        ssh_key_environment_create: Union[
            SshKeyEnvironmentCreate,
            SshKeyEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[SshKey]:
        """
        Create an SSH key and link it to the given environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/ssh-keys",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, ssh_key_environment_create)

        return DevopnessResponse(response, SshKey)

    async def delete_ssh_key(
        self,
        ssh_key_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given SSH key

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssh-keys/{ssh_key_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_ssh_key(
        self,
        ssh_key_id: int,
    ) -> DevopnessResponse[SshKey]:
        """
        Get a SSH key by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssh-keys/{ssh_key_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, SshKey)

    async def list_environment_ssh_keys(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[SshKeyRelation]]:
        """
        Return a list of all SSH keys added to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/ssh-keys",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[SshKeyRelation])

    async def update_ssh_key(
        self,
        ssh_key_id: int,
        ssh_key_update: Union[
            SshKeyUpdate,
            SshKeyUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing SSH key

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/ssh-keys/{ssh_key_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, ssh_key_update)

        return DevopnessResponse(response, None)
