"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import Member, MemberRelation
from ..utils import parse_query_string


class TeamsMembersApiService(DevopnessBaseService):
    """
    TeamsMembersApiService - Auto Generated
    """

    def delete_team_member(
        self,
        team_id: int,
        user_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given team member

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}/members/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_team_member(
        self,
        team_id: int,
        user_id: int,
    ) -> DevopnessResponse[Member]:
        """
        Get a member of team by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}/members/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, Member)

    def list_team_members(
        self,
        team_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[MemberRelation]]:
        """
        Return a list of all members belonging to a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/teams/{team_id}/members",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[MemberRelation])


class TeamsMembersApiServiceAsync(DevopnessBaseServiceAsync):
    """
    TeamsMembersApiServiceAsync - Auto Generated
    """

    async def delete_team_member(
        self,
        team_id: int,
        user_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given team member

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}/members/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_team_member(
        self,
        team_id: int,
        user_id: int,
    ) -> DevopnessResponse[Member]:
        """
        Get a member of team by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/teams/{team_id}/members/{user_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, Member)

    async def list_team_members(
        self,
        team_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[MemberRelation]]:
        """
        Return a list of all members belonging to a team

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/teams/{team_id}/members",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[MemberRelation])
