"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import EnvironmentRelation
from ..utils import parse_query_string


class UsersEnvironmentsApiService(DevopnessBaseService):
    """
    UsersEnvironmentsApiService - Auto Generated
    """

    def list_user_environments(
        self,
        user_id: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
        subscription_id: Optional[int] = None,
    ) -> DevopnessResponse[List[EnvironmentRelation]]:
        """
        Return a list of all environments owned by a user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
                "subscription_id": subscription_id,
            }
        )

        endpoint_parts = [
            f"/users/{user_id}/environments",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[EnvironmentRelation])


class UsersEnvironmentsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    UsersEnvironmentsApiServiceAsync - Auto Generated
    """

    async def list_user_environments(
        self,
        user_id: str,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
        subscription_id: Optional[int] = None,
    ) -> DevopnessResponse[List[EnvironmentRelation]]:
        """
        Return a list of all environments owned by a user

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
                "subscription_id": subscription_id,
            }
        )

        endpoint_parts = [
            f"/users/{user_id}/environments",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[EnvironmentRelation])
