"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import List, Optional, Union

from .. import DevopnessBaseService, DevopnessBaseServiceAsync, DevopnessResponse
from ..models import (
    VirtualHost,
    VirtualHostEnvironmentCreate,
    VirtualHostEnvironmentCreatePlain,
    VirtualHostGetStatus,
    VirtualHostGetStatusPlain,
    VirtualHostRelation,
    VirtualHostUpdate,
    VirtualHostUpdatePlain,
)
from ..utils import parse_query_string


class VirtualHostsApiService(DevopnessBaseService):
    """
    VirtualHostsApiService - Auto Generated
    """

    def add_environment_virtual_host(
        self,
        environment_id: int,
        virtual_host_environment_create: Union[
            VirtualHostEnvironmentCreate,
            VirtualHostEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[VirtualHost]:
        """
        Create a new virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/virtual-hosts",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, virtual_host_environment_create)

        return DevopnessResponse(response, VirtualHost)

    def delete_virtual_host(
        self,
        virtual_host_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._delete(endpoint)

        return DevopnessResponse(response, None)

    def get_status_virtual_host(
        self,
        virtual_host_id: int,
        virtual_host_get_status: Union[
            VirtualHostGetStatus,
            VirtualHostGetStatusPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Get current status of a virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}/get-status",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._post(endpoint, virtual_host_get_status)

        return DevopnessResponse(response, None)

    def get_virtual_host(
        self,
        virtual_host_id: int,
    ) -> DevopnessResponse[VirtualHost]:
        """
        Get a virtual host by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, VirtualHost)

    def list_environment_virtual_hosts(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[VirtualHostRelation]]:
        """
        Return a list of all Virtual Hosts belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/virtual-hosts",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._get(endpoint)

        return DevopnessResponse(response, List[VirtualHostRelation])

    def update_virtual_host(
        self,
        virtual_host_id: int,
        virtual_host_update: Union[
            VirtualHostUpdate,
            VirtualHostUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = self._put(endpoint, virtual_host_update)

        return DevopnessResponse(response, None)


class VirtualHostsApiServiceAsync(DevopnessBaseServiceAsync):
    """
    VirtualHostsApiServiceAsync - Auto Generated
    """

    async def add_environment_virtual_host(
        self,
        environment_id: int,
        virtual_host_environment_create: Union[
            VirtualHostEnvironmentCreate,
            VirtualHostEnvironmentCreatePlain,
        ],
    ) -> DevopnessResponse[VirtualHost]:
        """
        Create a new virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/environments/{environment_id}/virtual-hosts",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, virtual_host_environment_create)

        return DevopnessResponse(response, VirtualHost)

    async def delete_virtual_host(
        self,
        virtual_host_id: int,
    ) -> DevopnessResponse[None]:
        """
        Delete a given virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._delete(endpoint)

        return DevopnessResponse(response, None)

    async def get_status_virtual_host(
        self,
        virtual_host_id: int,
        virtual_host_get_status: Union[
            VirtualHostGetStatus,
            VirtualHostGetStatusPlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Get current status of a virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}/get-status",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._post(endpoint, virtual_host_get_status)

        return DevopnessResponse(response, None)

    async def get_virtual_host(
        self,
        virtual_host_id: int,
    ) -> DevopnessResponse[VirtualHost]:
        """
        Get a virtual host by ID

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, VirtualHost)

    async def list_environment_virtual_hosts(
        self,
        environment_id: int,
        page: Optional[int] = None,
        per_page: Optional[int] = None,
    ) -> DevopnessResponse[List[VirtualHostRelation]]:
        """
        Return a list of all Virtual Hosts belonging to an environment

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        query_string = parse_query_string(
            {
                "page": page,
                "per_page": per_page,
            }
        )

        endpoint_parts = [
            f"/environments/{environment_id}/virtual-hosts",
            f"?{query_string}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._get(endpoint)

        return DevopnessResponse(response, List[VirtualHostRelation])

    async def update_virtual_host(
        self,
        virtual_host_id: int,
        virtual_host_update: Union[
            VirtualHostUpdate,
            VirtualHostUpdatePlain,
        ],
    ) -> DevopnessResponse[None]:
        """
        Update an existing virtual host

        Raises:
            DevopnessApiError: If an API request error occurs.
            DevopnessNetworkError: If a network error occurs.
        """

        endpoint_parts = [
            f"/virtual-hosts/{virtual_host_id}",
        ]

        endpoint: str = "".join(endpoint_parts)

        response = await self._put(endpoint, virtual_host_update)

        return DevopnessResponse(response, None)
