"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    Required,
    TypedDict,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel


class ActionDeploymentCommit(DevopnessBaseModel):
    """
    ActionDeploymentCommit

    Attributes:
        repository (str): The repository of the deployed application
        author_name (str): The author of the commit
        author_email (str): The commit author&#39;s email
        committed_at (datetime): The date and time when the commit was created
        hash (str): The commit hash used on deployment
        message (str): The commit message
        url (str): The commit URL on the source provider
        clone_url (str): The URL to clone the repository on the specific commit
        download_url (str): The URL to download the commit source code
    """

    repository: StrictStr = Field(
        description="The repository of the deployed application"
    )
    author_name: StrictStr = Field(description="The author of the commit")
    author_email: StrictStr = Field(description="The commit author's email")
    committed_at: datetime = Field(
        description="The date and time when the commit was created"
    )
    hash: StrictStr = Field(description="The commit hash used on deployment")
    message: StrictStr = Field(description="The commit message")
    url: StrictStr = Field(description="The commit URL on the source provider")
    clone_url: StrictStr = Field(
        description="The URL to clone the repository on the specific commit"
    )
    download_url: StrictStr = Field(
        description="The URL to download the commit source code"
    )


class ActionDeploymentCommitPlain(TypedDict, total=False):
    """
    Plain version of ActionDeploymentCommit.
    """

    repository: Required[str]
    author_name: Required[str]
    author_email: Required[str]
    committed_at: Required[datetime]
    hash: Required[str]
    message: Required[str]
    url: Required[str]
    clone_url: Required[str]
    download_url: Required[str]
