"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    List,
    Optional,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr
from typing_extensions import Annotated

from .. import DevopnessBaseModel
from .action_status import ActionStatus, ActionStatusPlain
from .action_status_reason_code import (
    ActionStatusReasonCode,
    ActionStatusReasonCodePlain,
)
from .action_step import ActionStep, ActionStepPlain
from .action_target_data import ActionTargetData, ActionTargetDataPlain


class ActionTarget(DevopnessBaseModel):
    """
    ActionTarget

    Attributes:
        id (int, optional): The ID of the action target
        resource_type (str, optional): The type of the cloud resource on which the action must be performed
        resource_type_human_readable (str, optional): Human readable version of the resource type
        resource_id (int, optional): The Id of the cloud resource on which the action must be performed
        status (ActionStatus, optional):
        status_human_readable (str, optional): Human readable version of the action status
        status_reason_code (ActionStatusReasonCode, optional):
        status_reason_human_readable (str, optional): Human readable version of the status reason code
        total_steps (int, optional): The total number of steps to complete the action
        current_step (ActionStep, optional):
        steps (List[ActionStep], optional): The list of action steps
        resource_data (ActionTargetData, optional):
        started_at (datetime, optional): The date and time when the action started execution (i.e., left the &#x60;pending/queued&#x60; status)
        completed_at (datetime, optional): The date and time when the action has finished execution
        created_at (datetime, optional): The date and time when the record was created
        updated_at (datetime, optional): The date and time when the record was last updated
    """

    id: Optional[StrictInt] = Field(
        default=None, description="The ID of the action target"
    )
    resource_type: Optional[StrictStr] = Field(
        default=None,
        description="The type of the cloud resource on which the action must be performed",
    )
    resource_type_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the resource type"
    )
    resource_id: Optional[StrictInt] = Field(
        default=None,
        description="The Id of the cloud resource on which the action must be performed",
    )
    status: Optional[ActionStatus] = None
    status_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the action status"
    )
    status_reason_code: Optional[ActionStatusReasonCode] = None
    status_reason_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the status reason code"
    )
    total_steps: Optional[Annotated[int, Field(le=127, strict=True, ge=0)]] = Field(
        default=None, description="The total number of steps to complete the action"
    )
    current_step: Optional[ActionStep] = None
    steps: Optional[List[Optional[ActionStep]]] = Field(
        default=None, description="The list of action steps"
    )
    resource_data: Optional[ActionTargetData] = None
    started_at: Optional[datetime] = Field(
        default=None,
        description="The date and time when the action started execution (i.e., left the `pending/queued` status)",
    )
    completed_at: Optional[datetime] = Field(
        default=None,
        description="The date and time when the action has finished execution",
    )
    created_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class ActionTargetPlain(TypedDict, total=False):
    """
    Plain version of ActionTarget.
    """

    id: Optional[int]
    resource_type: Optional[str]
    resource_type_human_readable: Optional[str]
    resource_id: Optional[int]
    status: Optional[
        Union[
            ActionStatus,
            ActionStatusPlain,
        ]
    ]
    status_human_readable: Optional[str]
    status_reason_code: Optional[
        Union[
            ActionStatusReasonCode,
            ActionStatusReasonCodePlain,
        ]
    ]
    status_reason_human_readable: Optional[str]
    total_steps: Optional[int]
    current_step: Optional[
        Union[
            ActionStep,
            ActionStepPlain,
        ]
    ]
    steps: Optional[
        List[
            Union[
                ActionStep,
                ActionStepPlain,
            ]
        ]
    ]
    resource_data: Optional[
        Union[
            ActionTargetData,
            ActionTargetDataPlain,
        ]
    ]
    started_at: Optional[datetime]
    completed_at: Optional[datetime]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
