"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .cloud_provider_code import CloudProviderCode, CloudProviderCodePlain
from .provider_type import ProviderType, ProviderTypePlain


class ActionTargetCredentialData(DevopnessBaseModel):
    """
    ActionTargetCredentialData

    Attributes:
        id (int): The unique id of the credential
        name (str): The name of the credential
        provider_type (ProviderType):
        provider_code (CloudProviderCode):
        provider_name (str): The name of the cloud provider of the credential
        provider_name_human_readable (str): The human readable version of the provider name
    """

    id: StrictInt = Field(description="The unique id of the credential")
    name: StrictStr = Field(description="The name of the credential")
    provider_type: ProviderType
    provider_code: CloudProviderCode
    provider_name: StrictStr = Field(
        description="The name of the cloud provider of the credential"
    )
    provider_name_human_readable: StrictStr = Field(
        description="The human readable version of the provider name"
    )


class ActionTargetCredentialDataPlain(TypedDict, total=False):
    """
    Plain version of ActionTargetCredentialData.
    """

    id: Required[int]
    name: Required[str]
    provider_type: Required[
        Union[
            ProviderType,
            ProviderTypePlain,
        ]
    ]
    provider_code: Required[
        Union[
            CloudProviderCode,
            CloudProviderCodePlain,
        ]
    ]
    provider_name: Required[str]
    provider_name_human_readable: Required[str]
