"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .application_last_deployments import (
    ApplicationLastDeployments,
    ApplicationLastDeploymentsPlain,
)
from .credential_relation import CredentialRelation, CredentialRelationPlain
from .daemon_relation import DaemonRelation, DaemonRelationPlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .server_relation import ServerRelation, ServerRelationPlain
from .user_relation import UserRelation, UserRelationPlain
from .virtual_host_relation import VirtualHostRelation, VirtualHostRelationPlain


class Application(DevopnessBaseModel):
    """
    Application

    Attributes:
        id (int): Unique ID of the application
        project_id (int): Numeric ID of the project to which the application belongs to
        environment_id (int): Numeric ID of the environment to which the application belongs to
        created_by (int): The id of the user who created the application and to whom the application belongs
        name (str): The application&#39;s unique name
        repository (str): The full name of a repository (&#x60;repository_owner/repository_name&#x60;) containing the application source code.
        repository_name (str): The name part of a repository full name (&#x60;repository_owner/repository_name&#x60;)
        repository_owner (str): The owner part of a repository full name (&#x60;repository_owner/repository_name&#x60;)
        default_branch (str): The version control branch that, by default, will be used when a deployment is triggered and no other branch name is informed.
        programming_language (str): The programming language runtime environment to be used to serve the application. E.g.: if a front-end web app is developed using Node.js, but should be served statically (a SPA application, for instance) then this field value should be &#x60;html&#x60;.
        programming_language_human_readable (str): The human readable version of the programming language of the application.
        engine_version (str): The language runtime engine version to be used to execute this application on the deployed servers
        framework (str): The base framework on top of which the application has been implemented - it might have impact on the steps to be performed during application deployment
        framework_human_readable (str): The human readable version of the framework of the application.
        root_directory (str): The relative directory where package manager&#39;s manifest files (&#x60;package.json&#x60;, &#x60;composer.json&#x60;, &#x60;yarn.lock&#x60;, etc) are located. It needs to be set for applications where the actual source code is not located in the top level directory of the repository.
        deployments_keep (int): The number of deployment history, logs and artifacts to keep stored in both devopness servers and user&#39;s servers. OR The number of deployment artifacts to be retained in the user&#39;s servers, making it easier and faster to rollback to previous versions
        install_dependencies_command (str): Indicates command that Devopness must execute to install application dependencies
        build_command (str): The optional command that should be executed once during deployment to build the source code and get the application in a ready state
        created_by_user (UserRelation):
        last_deployments (ApplicationLastDeployments):
        environment (EnvironmentRelation):
        servers (List[ServerRelation]):
        credential (CredentialRelation):
        virtual_hosts (List[VirtualHostRelation]):
        daemons (List[DaemonRelation]):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="Unique ID of the application")
    project_id: StrictInt = Field(
        description="Numeric ID of the project to which the application belongs to"
    )
    environment_id: StrictInt = Field(
        description="Numeric ID of the environment to which the application belongs to"
    )
    created_by: StrictInt = Field(
        description="The id of the user who created the application and to whom the application belongs"
    )
    name: StrictStr = Field(description="The application's unique name")
    repository: StrictStr = Field(
        description="The full name of a repository (`repository_owner/repository_name`) containing the application source code."
    )
    repository_name: StrictStr = Field(
        description="The name part of a repository full name (`repository_owner/repository_name`)"
    )
    repository_owner: StrictStr = Field(
        description="The owner part of a repository full name (`repository_owner/repository_name`)"
    )
    default_branch: StrictStr = Field(
        description="The version control branch that, by default, will be used when a deployment is triggered and no other branch name is informed."
    )
    programming_language: StrictStr = Field(
        description="The programming language runtime environment to be used to serve the application. E.g.: if a front-end web app is developed using Node.js, but should be served statically (a SPA application, for instance) then this field value should be `html`."
    )
    programming_language_human_readable: StrictStr = Field(
        description="The human readable version of the programming language of the application."
    )
    engine_version: StrictStr = Field(
        description="The language runtime engine version to be used to execute this application on the deployed servers"
    )
    framework: StrictStr = Field(
        description="The base framework on top of which the application has been implemented - it might have impact on the steps to be performed during application deployment"
    )
    framework_human_readable: StrictStr = Field(
        description="The human readable version of the framework of the application."
    )
    root_directory: StrictStr = Field(
        description="The relative directory where package manager's manifest files (`package.json`, `composer.json`, `yarn.lock`, etc) are located. It needs to be set for applications where the actual source code is not located in the top level directory of the repository."
    )
    deployments_keep: StrictInt = Field(
        description="The number of deployment history, logs and artifacts to keep stored in both devopness servers and user's servers. OR The number of deployment artifacts to be retained in the user's servers, making it easier and faster to rollback to previous versions"
    )
    install_dependencies_command: Optional[StrictStr] = Field(
        description="Indicates command that Devopness must execute to install application dependencies"
    )
    build_command: Optional[StrictStr] = Field(
        description="The optional command that should be executed once during deployment to build the source code and get the application in a ready state"
    )
    created_by_user: UserRelation
    last_deployments: ApplicationLastDeployments
    environment: Optional[EnvironmentRelation]
    servers: List[Optional[ServerRelation]]
    credential: Optional[CredentialRelation]
    virtual_hosts: List[Optional[VirtualHostRelation]]
    daemons: List[Optional[DaemonRelation]]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class ApplicationPlain(TypedDict, total=False):
    """
    Plain version of Application.
    """

    id: Required[int]
    project_id: Required[int]
    environment_id: Required[int]
    created_by: Required[int]
    name: Required[str]
    repository: Required[str]
    repository_name: Required[str]
    repository_owner: Required[str]
    default_branch: Required[str]
    programming_language: Required[str]
    programming_language_human_readable: Required[str]
    engine_version: Required[str]
    framework: Required[str]
    framework_human_readable: Required[str]
    root_directory: Required[str]
    deployments_keep: Required[int]
    install_dependencies_command: Required[str]
    build_command: Required[str]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    last_deployments: Required[
        Union[
            ApplicationLastDeployments,
            ApplicationLastDeploymentsPlain,
        ]
    ]
    environment: Required[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    servers: Required[
        List[
            Union[
                ServerRelation,
                ServerRelationPlain,
            ]
        ]
    ]
    credential: Required[
        Union[
            CredentialRelation,
            CredentialRelationPlain,
        ]
    ]
    virtual_hosts: Required[
        List[
            Union[
                VirtualHostRelation,
                VirtualHostRelationPlain,
            ]
        ]
    ]
    daemons: Required[
        List[
            Union[
                DaemonRelation,
                DaemonRelationPlain,
            ]
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
