"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class ApplicationUpdate(DevopnessBaseModel):
    """
    ApplicationUpdate

    Attributes:
        id (int): The unique ID of the given Application.
        name (str): The application&#39;s unique name. Must not be greater than 60 characters.
        build_command (str, optional): The optional command that should be executed once during deployment to build the source code and get the application in a ready state.
        engine_version (str): The language runtime engine version to be used to execute this application on the deployed servers. Must be at least 1 character. Must not be greater than 10 characters.
        framework (str): The base framework on top of which the application has been implemented - it might have impact on the steps to be performed during application deployment. Must not be greater than 30 characters.
        programming_language (str): The programming language runtime environment to be used to serve the application. E.g.: if a front-end web app is developed using Node.js, but should be served statically (a SPA application, for instance) then this field value should be &#x60;html&#x60;. Must not be greater than 30 characters.
        repository (str, optional): The full name of a repository (&#x60;repository_owner/repository_name&#x60;) containing the application source code. Must not be greater than 100 characters.
        credential_id (int, optional): Numeric ID of the credential to source provider where the repository is hosted. This field is required when &lt;code&gt;repository&lt;/code&gt; is present.
        root_directory (str, optional): The relative directory where package manager&#39;s manifest files (&#x60;package.json&#x60;, &#x60;composer.json&#x60;, &#x60;yarn.lock&#x60;, etc) are located. It needs to be set for applications where the actual source code is not located in the top level directory of the repository. Must start with one of &lt;code&gt;/&lt;/code&gt;.
        default_branch (str): The version control branch that, by default, will be used when a deployment is triggered and no other branch name is informed. Must not be greater than 200 characters.
        deployments_keep (int, optional): The number of deployment history, logs and artifacts to keep stored in both devopness servers and user&#39;s servers. OR The number of deployment artifacts to be retained in the user&#39;s servers, making it easier and faster to rollback to previous versions. Must be at least 1. Must not be greater than 10.
        install_dependencies_command (str, optional): Indicates command that Devopness must execute to install application dependencies.
    """

    id: StrictInt = Field(description="The unique ID of the given Application.")
    name: StrictStr = Field(
        description="The application's unique name. Must not be greater than 60 characters."
    )
    build_command: Optional[StrictStr] = Field(
        default=None,
        description="The optional command that should be executed once during deployment to build the source code and get the application in a ready state.",
    )
    engine_version: StrictStr = Field(
        description="The language runtime engine version to be used to execute this application on the deployed servers. Must be at least 1 character. Must not be greater than 10 characters."
    )
    framework: StrictStr = Field(
        description="The base framework on top of which the application has been implemented - it might have impact on the steps to be performed during application deployment. Must not be greater than 30 characters."
    )
    programming_language: StrictStr = Field(
        description="The programming language runtime environment to be used to serve the application. E.g.: if a front-end web app is developed using Node.js, but should be served statically (a SPA application, for instance) then this field value should be `html`. Must not be greater than 30 characters."
    )
    repository: Optional[StrictStr] = Field(
        default=None,
        description="The full name of a repository (`repository_owner/repository_name`) containing the application source code. Must not be greater than 100 characters.",
    )
    credential_id: Optional[StrictInt] = Field(
        default=None,
        description="Numeric ID of the credential to source provider where the repository is hosted. This field is required when <code>repository</code> is present.",
    )
    root_directory: Optional[StrictStr] = Field(
        default=None,
        description="The relative directory where package manager's manifest files (`package.json`, `composer.json`, `yarn.lock`, etc) are located. It needs to be set for applications where the actual source code is not located in the top level directory of the repository. Must start with one of <code>/</code>.",
    )
    default_branch: StrictStr = Field(
        description="The version control branch that, by default, will be used when a deployment is triggered and no other branch name is informed. Must not be greater than 200 characters."
    )
    deployments_keep: Optional[StrictInt] = Field(
        default=None,
        description="The number of deployment history, logs and artifacts to keep stored in both devopness servers and user's servers. OR The number of deployment artifacts to be retained in the user's servers, making it easier and faster to rollback to previous versions. Must be at least 1. Must not be greater than 10.",
    )
    install_dependencies_command: Optional[StrictStr] = Field(
        default=None,
        description="Indicates command that Devopness must execute to install application dependencies.",
    )


class ApplicationUpdatePlain(TypedDict, total=False):
    """
    Plain version of ApplicationUpdate.
    """

    id: Required[int]
    name: Required[str]
    build_command: Optional[str]
    engine_version: Required[str]
    framework: Required[str]
    programming_language: Required[str]
    repository: Optional[str]
    credential_id: Optional[int]
    root_directory: Optional[str]
    default_branch: Required[str]
    deployments_keep: Optional[int]
    install_dependencies_command: Optional[str]
