"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictFloat, StrictInt, StrictStr

from .. import DevopnessBaseModel


class CloudInstanceRelation(DevopnessBaseModel):
    """
    CloudInstanceRelation

    Attributes:
        name (str): The name of the cloud instance
        type (str): The type of the cloud instance
        family (str): The family to which the instance belongs
        architecture (str): The type of CPU used in the cloud server (x86_64 or arm64)
        default_disk_size (int): The default disk size (in GB) used to instance
        price_hourly (float): The price per hour of the instance
        price_monthly (float): The price per month of the instance
        price_currency (str): The currency of the prices
        vcpus (int): The number of virtual CPU of the instance
        memory (int): The RAM memory size (in MB) of the instance
    """

    name: StrictStr = Field(description="The name of the cloud instance")
    type: StrictStr = Field(description="The type of the cloud instance")
    family: StrictStr = Field(description="The family to which the instance belongs")
    architecture: Optional[StrictStr] = Field(
        description="The type of CPU used in the cloud server (x86_64 or arm64)"
    )
    default_disk_size: StrictInt = Field(
        description="The default disk size (in GB) used to instance"
    )
    price_hourly: Union[StrictFloat, StrictInt] = Field(
        description="The price per hour of the instance"
    )
    price_monthly: Union[StrictFloat, StrictInt] = Field(
        description="The price per month of the instance"
    )
    price_currency: StrictStr = Field(description="The currency of the prices")
    vcpus: StrictInt = Field(description="The number of virtual CPU of the instance")
    memory: StrictInt = Field(description="The RAM memory size (in MB) of the instance")


class CloudInstanceRelationPlain(TypedDict, total=False):
    """
    Plain version of CloudInstanceRelation.
    """

    name: Required[str]
    type: Required[str]
    family: Required[str]
    architecture: Required[str]
    default_disk_size: Required[int]
    price_hourly: Required[float]
    price_monthly: Required[float]
    price_currency: Required[str]
    vcpus: Required[int]
    memory: Required[int]
