"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .cloud_os_version_code import CloudOsVersionCode, CloudOsVersionCodePlain


class CloudServiceSettingsAzureRm(DevopnessBaseModel):
    """
    CloudServiceSettingsAzureRm

    Attributes:
        instance_type (str): The instance type to be launched on the cloud provider
        region (str): Datacenter region where the cloud instance will be launched
        region_human_readable (str, optional): Human readable version of the server region
        storage_size (int): The storage&#39;s size of the cloud instance
        os_version_code (CloudOsVersionCode):
    """

    instance_type: StrictStr = Field(
        description="The instance type to be launched on the cloud provider"
    )
    region: StrictStr = Field(
        description="Datacenter region where the cloud instance will be launched"
    )
    region_human_readable: Optional[StrictStr] = Field(
        default=None, description="Human readable version of the server region"
    )
    storage_size: StrictInt = Field(
        description="The storage's size of the cloud instance"
    )
    os_version_code: Optional[CloudOsVersionCode]


class CloudServiceSettingsAzureRmPlain(TypedDict, total=False):
    """
    Plain version of CloudServiceSettingsAzureRm.
    """

    instance_type: Required[str]
    region: Required[str]
    region_human_readable: Optional[str]
    storage_size: Required[int]
    os_version_code: Required[
        Union[
            CloudOsVersionCode,
            CloudOsVersionCodePlain,
        ]
    ]
