"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictStr

from .. import DevopnessBaseModel
from .source_provider_name import SourceProviderName, SourceProviderNamePlain


class Commit(DevopnessBaseModel):
    """
    Commit

    Attributes:
        hash (str): The commit comment&#39;s full hash that uniquely identify it
        message (str): The commit&#39;s comment message
        committed_at (str): The date and time when the commit has been submitted
        provider (SourceProviderName):
        repository (str): The full name of the repository (&#x60;owner/repository&#x60;) to which the commit belongs to
        url (str): The direct URL for accessing commit details on the provider&#39;s web application
        author_email (str): The e-mail of the commit&#39;s author
        author_name (str): The name of the commit&#39;s author
    """

    hash: StrictStr = Field(
        description="The commit comment's full hash that uniquely identify it"
    )
    message: StrictStr = Field(description="The commit's comment message")
    committed_at: StrictStr = Field(
        description="The date and time when the commit has been submitted"
    )
    provider: SourceProviderName
    repository: StrictStr = Field(
        description="The full name of the repository (`owner/repository`) to which the commit belongs to"
    )
    url: StrictStr = Field(
        description="The direct URL for accessing commit details on the provider's web application"
    )
    author_email: StrictStr = Field(description="The e-mail of the commit's author")
    author_name: StrictStr = Field(description="The name of the commit's author")


class CommitPlain(TypedDict, total=False):
    """
    Plain version of Commit.
    """

    hash: Required[str]
    message: Required[str]
    committed_at: Required[str]
    provider: Required[
        Union[
            SourceProviderName,
            SourceProviderNamePlain,
        ]
    ]
    repository: Required[str]
    url: Required[str]
    author_email: Required[str]
    author_name: Required[str]
