"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .provider_relation import ProviderRelation, ProviderRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class Credential(DevopnessBaseModel):
    """
    Credential

    Attributes:
        id (int): The unique ID of the credential
        name (str): The name of the credential
        provider (ProviderRelation):
        provider_type (str): The type of the credential
        provider_type_human_readable (str): The human readable version of the type of the credential
        active (bool): If this credential is active or not
        created_by_user (UserRelation):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the credential")
    name: StrictStr = Field(description="The name of the credential")
    provider: ProviderRelation
    provider_type: StrictStr = Field(description="The type of the credential")
    provider_type_human_readable: StrictStr = Field(
        description="The human readable version of the type of the credential"
    )
    active: StrictBool = Field(description="If this credential is active or not")
    created_by_user: UserRelation
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class CredentialPlain(TypedDict, total=False):
    """
    Plain version of Credential.
    """

    id: Required[int]
    name: Required[str]
    provider: Required[
        Union[
            ProviderRelation,
            ProviderRelationPlain,
        ]
    ]
    provider_type: Required[str]
    provider_type_human_readable: Required[str]
    active: Required[bool]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
