"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .action_relation import ActionRelation, ActionRelationPlain
from .application_relation import ApplicationRelation, ApplicationRelationPlain
from .cron_job_pattern import CronJobPattern, CronJobPatternPlain
from .environment_relation import EnvironmentRelation, EnvironmentRelationPlain
from .project_relation import ProjectRelation, ProjectRelationPlain
from .server_relation import ServerRelation, ServerRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class CronJob(DevopnessBaseModel):
    """
    CronJob

    Attributes:
        id (int): The ID of the given cron job
        name (str): The name of the cron job
        command (str): The command line to be executed when running the cron job
        run_as_user (str): The name of the Unix user on behalf of which the cron job will be executed
        pattern (str): A cron expression consisting of Minute, Hour, Day of Month, Month and Day of Week subexpressions
        pattern_human_readable (CronJobPattern):
        is_auto_generated (bool): Indicates if the cron job was auto_generated by &#x60;Devopness&#x60; itself
        last_action (ActionRelation):
        created_by_user (UserRelation):
        application (ApplicationRelation):
        project (ProjectRelation):
        environment (EnvironmentRelation):
        servers (List[ServerRelation]):
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The ID of the given cron job")
    name: StrictStr = Field(description="The name of the cron job")
    command: StrictStr = Field(
        description="The command line to be executed when running the cron job"
    )
    run_as_user: StrictStr = Field(
        description="The name of the Unix user on behalf of which the cron job will be executed"
    )
    pattern: StrictStr = Field(
        description="A cron expression consisting of Minute, Hour, Day of Month, Month and Day of Week subexpressions"
    )
    pattern_human_readable: CronJobPattern
    is_auto_generated: StrictBool = Field(
        description="Indicates if the cron job was auto_generated by `Devopness` itself"
    )
    last_action: Optional[ActionRelation]
    created_by_user: UserRelation
    application: Optional[ApplicationRelation]
    project: Optional[ProjectRelation]
    environment: Optional[EnvironmentRelation]
    servers: List[Optional[ServerRelation]]
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class CronJobPlain(TypedDict, total=False):
    """
    Plain version of CronJob.
    """

    id: Required[int]
    name: Required[str]
    command: Required[str]
    run_as_user: Required[str]
    pattern: Required[str]
    pattern_human_readable: Required[
        Union[
            CronJobPattern,
            CronJobPatternPlain,
        ]
    ]
    is_auto_generated: Required[bool]
    last_action: Required[
        Union[
            ActionRelation,
            ActionRelationPlain,
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    application: Required[
        Union[
            ApplicationRelation,
            ApplicationRelationPlain,
        ]
    ]
    project: Required[
        Union[
            ProjectRelation,
            ProjectRelationPlain,
        ]
    ]
    environment: Required[
        Union[
            EnvironmentRelation,
            EnvironmentRelationPlain,
        ]
    ]
    servers: Required[
        List[
            Union[
                ServerRelation,
                ServerRelationPlain,
            ]
        ]
    ]
    created_at: Required[str]
    updated_at: Required[str]
