"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .resource_to_be_linked import ResourceToBeLinked, ResourceToBeLinkedPlain


class CronJobEnvironmentCreate(DevopnessBaseModel):
    """
    CronJobEnvironmentCreate

    Attributes:
        linked_resources (List[ResourceToBeLinked], optional): The resources to be linked with this resource
        name (str): The name of the cron job. Must not be greater than 60 characters.
        command (str): The command line to be executed when running the cron job. Must be at least 5 characters. Must not be greater than 255 characters.
        pattern (str): A cron expression consisting of Minute, Hour, Day of Month, Month and Day of Week subexpressions.
        run_as_user (str): The name of the system user on behalf of which the cron job will be executed. Must not be greater than 60 characters.
        application_id (int, optional): Numeric ID of the application to which the cron job belongs to.
    """

    linked_resources: Optional[List[ResourceToBeLinked]] = Field(
        default=None, description="The resources to be linked with this resource"
    )
    name: StrictStr = Field(
        description="The name of the cron job. Must not be greater than 60 characters."
    )
    command: StrictStr = Field(
        description="The command line to be executed when running the cron job. Must be at least 5 characters. Must not be greater than 255 characters."
    )
    pattern: StrictStr = Field(
        description="A cron expression consisting of Minute, Hour, Day of Month, Month and Day of Week subexpressions."
    )
    run_as_user: StrictStr = Field(
        description="The name of the system user on behalf of which the cron job will be executed. Must not be greater than 60 characters."
    )
    application_id: Optional[StrictInt] = Field(
        default=None,
        description="Numeric ID of the application to which the cron job belongs to.",
    )


class CronJobEnvironmentCreatePlain(TypedDict, total=False):
    """
    Plain version of CronJobEnvironmentCreate.
    """

    linked_resources: Optional[
        List[
            Union[
                ResourceToBeLinked,
                ResourceToBeLinkedPlain,
            ]
        ]
    ]
    name: Required[str]
    command: Required[str]
    pattern: Required[str]
    run_as_user: Required[str]
    application_id: Optional[int]
