"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Optional,
    Required,
    TypedDict,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel


class DaemonUpdate(DevopnessBaseModel):
    """
    DaemonUpdate

    Attributes:
        id (int): The unique ID of the given Daemon.
        command (str): The command line to be executed to start the daemon. Must not be greater than 255 characters.
        process_count (int): The number of daemon process instances of the program to run simultaneously. Must be at least 1. Must not be greater than 99.
        working_directory (str): The working directory where the Daemon command will be executed. If the Daemon is linked to an application, the path must be a relative path to the application root directory. If the Daemon is not linked to an application, the value must be an absolute path. Must start with one of &lt;code&gt;/&lt;/code&gt; Must not be greater than 255 characters.
        run_as_user (str): The name of the Unix user on behalf of which the daemon will run. Must not be greater than 60 characters.
        name (str): The name entered by the user (or auto-generated by &#x60;devopness&#x60;) to uniquely identify the daemon. Must contain only letters, numbers, dashes and underscores. Must not be greater than 60 characters.
        application_id (int, optional): The ID of the application to be linked to the daemon. The value of &#x60;working_directory&#x60; will be relative to the application directory.
    """

    id: StrictInt = Field(description="The unique ID of the given Daemon.")
    command: StrictStr = Field(
        description="The command line to be executed to start the daemon. Must not be greater than 255 characters."
    )
    process_count: StrictInt = Field(
        description="The number of daemon process instances of the program to run simultaneously. Must be at least 1. Must not be greater than 99."
    )
    working_directory: Optional[StrictStr] = Field(
        description="The working directory where the Daemon command will be executed. If the Daemon is linked to an application, the path must be a relative path to the application root directory. If the Daemon is not linked to an application, the value must be an absolute path. Must start with one of <code>/</code> Must not be greater than 255 characters."
    )
    run_as_user: StrictStr = Field(
        description="The name of the Unix user on behalf of which the daemon will run. Must not be greater than 60 characters."
    )
    name: StrictStr = Field(
        description="The name entered by the user (or auto-generated by `devopness`) to uniquely identify the daemon. Must contain only letters, numbers, dashes and underscores. Must not be greater than 60 characters."
    )
    application_id: Optional[StrictInt] = Field(
        default=None,
        description="The ID of the application to be linked to the daemon. The value of `working_directory` will be relative to the application directory.",
    )


class DaemonUpdatePlain(TypedDict, total=False):
    """
    Plain version of DaemonUpdate.
    """

    id: Required[int]
    command: Required[str]
    process_count: Required[int]
    working_directory: Required[str]
    run_as_user: Required[str]
    name: Required[str]
    application_id: Optional[int]
