"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictBool, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .environment_type import EnvironmentType, EnvironmentTypePlain
from .resource_summary_item import ResourceSummaryItem, ResourceSummaryItemPlain
from .team_relation import TeamRelation, TeamRelationPlain
from .user_relation import UserRelation, UserRelationPlain


class Environment(DevopnessBaseModel):
    """
    Environment

    Attributes:
        id (int): Unique id of the given record
        type (EnvironmentType):
        type_human_readable (str): The human readable version of the type
        name (str): Environment&#39;s name
        description (str): Environment&#39;s description
        is_archived (bool): Indicates whether the record was archived
        resource_summary (List[ResourceSummaryItem], optional): Summary of the resource
        teams (List[TeamRelation]):
        created_by_user (UserRelation):
        current_user_permissions (List[str]): The list of permissions granted for this role
        created_at (str): The date and time when the record was created
        updated_at (str): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="Unique id of the given record")
    type: EnvironmentType
    type_human_readable: StrictStr = Field(
        description="The human readable version of the type"
    )
    name: StrictStr = Field(description="Environment's name")
    description: Optional[StrictStr] = Field(description="Environment's description")
    is_archived: StrictBool = Field(
        description="Indicates whether the record was archived"
    )
    resource_summary: Optional[List[ResourceSummaryItem]] = Field(
        default=None, description="Summary of the resource"
    )
    teams: List[Optional[TeamRelation]]
    created_by_user: UserRelation
    current_user_permissions: List[StrictStr] = Field(
        description="The list of permissions granted for this role"
    )
    created_at: StrictStr = Field(
        description="The date and time when the record was created"
    )
    updated_at: StrictStr = Field(
        description="The date and time when the record was last updated"
    )


class EnvironmentPlain(TypedDict, total=False):
    """
    Plain version of Environment.
    """

    id: Required[int]
    type: Required[
        Union[
            EnvironmentType,
            EnvironmentTypePlain,
        ]
    ]
    type_human_readable: Required[str]
    name: Required[str]
    description: Required[str]
    is_archived: Required[bool]
    resource_summary: Optional[
        List[
            Union[
                ResourceSummaryItem,
                ResourceSummaryItemPlain,
            ]
        ]
    ]
    teams: Required[
        List[
            Union[
                TeamRelation,
                TeamRelationPlain,
            ]
        ]
    ]
    created_by_user: Required[
        Union[
            UserRelation,
            UserRelationPlain,
        ]
    ]
    current_user_permissions: Required[List[str]]
    created_at: Required[str]
    updated_at: Required[str]
