"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from datetime import datetime
from typing import (
    List,
    Optional,
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .linked_resource_summary_field import (
    LinkedResourceSummaryField,
    LinkedResourceSummaryFieldPlain,
)


class LinkedResourceData(DevopnessBaseModel):
    """
    LinkedResourceData

    Attributes:
        id (int): The unique ID of the resource
        name (str): Resource name
        summary_fields (List[LinkedResourceSummaryField], optional): The summary of linked resource fields
        created_at (datetime, optional): The date and time when the record was created
        updated_at (datetime, optional): The date and time when the record was last updated
    """

    id: StrictInt = Field(description="The unique ID of the resource")
    name: StrictStr = Field(description="Resource name")
    summary_fields: Optional[List[LinkedResourceSummaryField]] = Field(
        default=None, description="The summary of linked resource fields"
    )
    created_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was created"
    )
    updated_at: Optional[datetime] = Field(
        default=None, description="The date and time when the record was last updated"
    )


class LinkedResourceDataPlain(TypedDict, total=False):
    """
    Plain version of LinkedResourceData.
    """

    id: Required[int]
    name: Required[str]
    summary_fields: Optional[
        List[
            Union[
                LinkedResourceSummaryField,
                LinkedResourceSummaryFieldPlain,
            ]
        ]
    ]
    created_at: Optional[datetime]
    updated_at: Optional[datetime]
