"""
Devopness API Python SDK - Painless essential DevOps to everyone

Note:
    This is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
"""

from typing import (
    Required,
    TypedDict,
    Union,
)

from pydantic import Field, StrictInt, StrictStr

from .. import DevopnessBaseModel
from .network_provision_input import NetworkProvisionInput, NetworkProvisionInputPlain


class NetworkEnvironmentCreate(DevopnessBaseModel):
    """
    NetworkEnvironmentCreate

    Attributes:
        name (str): The network&#39;s name. Must not be one of &lt;code&gt;default&lt;/code&gt; Must be between 1 and 63 characters.
        provision_input (NetworkProvisionInput):
        credential_id (int): The ID of the cloud credential.
    """

    name: StrictStr = Field(
        description="The network's name. Must not be one of <code>default</code> Must be between 1 and 63 characters."
    )
    provision_input: NetworkProvisionInput
    credential_id: StrictInt = Field(description="The ID of the cloud credential.")


class NetworkEnvironmentCreatePlain(TypedDict, total=False):
    """
    Plain version of NetworkEnvironmentCreate.
    """

    name: Required[str]
    provision_input: Required[
        Union[
            NetworkProvisionInput,
            NetworkProvisionInputPlain,
        ]
    ]
    credential_id: Required[int]
